/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ExtendedEntity;
import com.lycanitesmobs.ExtendedPlayer;
import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.GuiHandler;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupBoss;
import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.api.IGroupIce;
import com.lycanitesmobs.core.entity.EntityFear;
import com.lycanitesmobs.core.entity.EntityHitArea;
import com.lycanitesmobs.core.entity.EntityItemCustom;
import com.lycanitesmobs.core.entity.ai.DirectNavigator;
import com.lycanitesmobs.core.entity.ai.EntityAIMoveRestriction;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.navigate.CreatureMoveHelper;
import com.lycanitesmobs.core.entity.navigate.CreaturePathNavigate;
import com.lycanitesmobs.core.entity.navigate.ICreatureNodeProcessor;
import com.lycanitesmobs.core.info.AltarInfo;
import com.lycanitesmobs.core.info.CreatureKnowledge;
import com.lycanitesmobs.core.info.DropRate;
import com.lycanitesmobs.core.info.ExtraMobBehaviour;
import com.lycanitesmobs.core.info.GroupInfo;
import com.lycanitesmobs.core.info.MobInfo;
import com.lycanitesmobs.core.info.SpawnInfo;
import com.lycanitesmobs.core.info.Subspecies;
import com.lycanitesmobs.core.inventory.ContainerCreature;
import com.lycanitesmobs.core.inventory.InventoryCreature;
import com.lycanitesmobs.core.pets.PetEntry;
import com.lycanitesmobs.core.spawning.SpawnTypeBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityCreatureBase
extends EntityLiving {
    public static Boolean ENABLE_HITAREAS = false;
    public static Map<Class, Double> baseHealthMap = new HashMap<Class, Double>();
    public MobInfo mobInfo;
    public GroupInfo group;
    public Subspecies subspecies = null;
    public EnumCreatureAttribute attribute = EnumCreatureAttribute.UNDEAD;
    public ExtraMobBehaviour extraMobBehaviour;
    public String spawnEventType = "";
    public int spawnEventCount = -1;
    public PetEntry petEntry;
    public boolean altarSummoned = false;
    public boolean forceBossHealthBar = false;
    public long updateTick = 0L;
    public float setWidth = 0.6f;
    public float setDepth = 0.6f;
    public float setHeight = 1.8f;
    public double sizeScale = 1.0;
    public EntityHitArea[][][] hitAreas;
    public float hitAreaWidthScale = 1.0f;
    public float hitAreaHeightScale = 1.0f;
    public int attackTime = 20;
    public int defense = 0;
    public int experience = 5;
    public byte attackPhase = 0;
    public byte attackPhaseMax = 0;
    public int fleeTime = 200;
    public int currentFleeTime = 0;
    public float fleeHealthPercent = 0.0f;
    public int battlePhase = 0;
    public int damageMax = 0;
    public boolean boss = false;
    public int bossRange = 60;
    public boolean isHostileByDefault = true;
    public boolean spreadFire = false;
    public boolean stealthPrev = false;
    public int currentBlockingTime = 0;
    public int blockingTime = 60;
    public EntityLivingBase pickupEntity;
    public boolean solidCollision = false;
    protected BlockPos homePosition = new BlockPos(0, 0, 0);
    protected float homeDistanceMax = -1.0f;
    protected BlockPos arenaCenter = null;
    public boolean firstSpawn = true;
    public SpawnTypeBase spawnedFromType = null;
    public boolean spawnsInBlock = false;
    public boolean spawnsUnderground = true;
    public boolean spawnsOnLand = true;
    public boolean spawnsInWater = false;
    public boolean isLavaCreature = false;
    public boolean isMinion = false;
    public boolean isTemporary = false;
    public int temporaryDuration = 0;
    public boolean forceNoDespawn = false;
    public boolean spawnedRare = false;
    private boolean leashAIActive = false;
    private EntityAIBase leashMoveTowardsRestrictionAI = new EntityAIMoveRestriction(this);
    public DirectNavigator directNavigator;
    private EntityLivingBase masterTarget;
    private EntityLivingBase parentTarget;
    private EntityLivingBase avoidTarget;
    public List<EntityPlayer> guiViewers = new ArrayList<EntityPlayer>();
    public int guiRefreshTick = 0;
    public int guiRefreshTime = 2;
    public short justAttacked = 0;
    public short justAttackedTime = (short)5;
    public boolean hasAttackSound = false;
    public boolean hasStepSound = true;
    public boolean hasJumpSound = false;
    public int flySoundSpeed = 0;
    public boolean extraAnimation01 = false;
    public BossInfoServer bossInfo;
    protected static final DataParameter<Byte> TARGET = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> ANIMATION = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> ATTACK_PHASE = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Float> STEALTH = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Byte> COLOR = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Byte> SUBSPECIES = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final DataParameter<ItemStack> EQUIPMENT_HEAD = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<ItemStack> EQUIPMENT_CHEST = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<ItemStack> EQUIPMENT_LEGS = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<ItemStack> EQUIPMENT_FEET = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<ItemStack> EQUIPMENT_BAG = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<ItemStack> EQUIPMENT_SADDLE = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187196_f);
    protected static final DataParameter<Optional<BlockPos>> ARENA = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187201_k);
    public boolean initiated = false;
    public InventoryCreature inventory;
    public List<DropRate> drops = new ArrayList<DropRate>();
    public EntityAITargetAttack aiTargetPlayer = new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class);
    public EntityAITargetRevenge aiDefendAnimals = new EntityAITargetRevenge(this).setHelpClasses(IAnimals.class);

    public EntityCreatureBase(World world) {
        super(world);
        this.field_70130_N = this.setWidth;
        this.field_70131_O = this.setHeight;
        this.field_70765_h = this.createMoveHelper();
        if (!this.canBurn()) {
            this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
            this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
            if (this.func_70648_aU()) {
                this.func_184644_a(PathNodeType.LAVA, 8.0f);
                if (!this.canBreatheAboveWater() || this.isLavaCreature) {
                    this.func_184644_a(PathNodeType.LAVA, 0.0f);
                }
            }
        }
        if (this.waterDamage()) {
            this.func_184644_a(PathNodeType.WATER, -1.0f);
        } else if (this.func_70648_aU()) {
            this.func_184644_a(PathNodeType.WATER, 8.0f);
            if (!this.canBreatheAboveWater()) {
                this.func_184644_a(PathNodeType.WATER, 0.0f);
            }
        }
        if (this.canWade() && this.func_70661_as() instanceof PathNavigateGround) {
            PathNavigateGround groundNavigator = (PathNavigateGround)this.func_70661_as();
            groundNavigator.func_179693_d(true);
        }
    }

    public void setupMob() {
        this.setWidth = (float)((double)this.setWidth * this.mobInfo.hitboxScale);
        this.setHeight = (float)((double)this.setHeight * this.mobInfo.hitboxScale);
        this.updateSize();
        if (this.mobInfo.sizeScale != 1.0) {
            this.setSizeScale(this.mobInfo.sizeScale);
        }
        this.field_70138_W = 0.5f;
        this.field_70728_aV = this.experience;
        this.inventory = new InventoryCreature(this.func_70005_c_(), this);
        if (this.mobInfo.defaultDrops) {
            this.loadItemDrops();
        }
        this.loadCustomDrops();
        this.field_70728_aV = this.experience;
        this.field_70178_ae = !this.canBurn();
    }

    public void loadItemDrops() {
    }

    public void loadCustomDrops() {
        for (DropRate drop : this.mobInfo.customDrops) {
            DropRate newDrop = new DropRate(drop.item.func_77946_l(), drop.chance).setMinAmount(drop.minAmount).setMaxAmount(drop.maxAmount).setChance(drop.chance).setSubspecies(drop.subspeciesID).setBurningDrop(drop.burningItem);
            this.drops.add(newDrop);
        }
    }

    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 20.0);
        baseAttributes.put("armor", 0.0);
        baseAttributes.put("movementSpeed", 1.0);
        baseAttributes.put("knockbackResistance", 0.0);
        baseAttributes.put("followRange", 35.0);
        baseAttributes.put("attackDamage", 1.0);
        baseAttributes.put("attackSpeed", 4.0);
        this.applyEntityAttributes(baseAttributes);
    }

    protected void applyEntityAttributes(HashMap<String, Double> baseAttributes) {
        this.mobInfo = MobInfo.mobClassToInfo.get(((Object)((Object)this)).getClass());
        this.group = this.mobInfo.group;
        this.extraMobBehaviour = new ExtraMobBehaviour(this);
        this.directNavigator = new DirectNavigator(this);
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188790_f);
        if (baseAttributes.containsKey("maxHealth")) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(baseAttributes.get("maxHealth") * this.getHealthMultiplier() + (double)this.getHealthBoost());
            baseHealthMap.put(((Object)((Object)this)).getClass(), baseAttributes.get("maxHealth"));
        }
        if (baseAttributes.containsKey("armor")) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(baseAttributes.get("armor").doubleValue());
        }
        if (baseAttributes.containsKey("movementSpeed")) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(baseAttributes.get("movementSpeed").doubleValue());
        }
        if (baseAttributes.containsKey("knockbackResistance")) {
            this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(baseAttributes.get("knockbackResistance").doubleValue());
        }
        if (baseAttributes.containsKey("followRange")) {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(baseAttributes.get("followRange").doubleValue());
        }
        if (baseAttributes.containsKey("attackDamage")) {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(baseAttributes.get("attackDamage").doubleValue());
        }
        if (baseAttributes.containsKey("attackSpeed")) {
            this.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111128_a(baseAttributes.get("attackSpeed").doubleValue());
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TARGET, (Object)0);
        this.field_70180_af.func_187214_a(ATTACK_PHASE, (Object)0);
        this.field_70180_af.func_187214_a(ANIMATION, (Object)0);
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
        this.field_70180_af.func_187214_a(STEALTH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(SUBSPECIES, (Object)0);
        this.field_70180_af.func_187214_a(ARENA, (Object)Optional.absent());
        InventoryCreature.registerDataParameters(this.field_70180_af);
        this.initiated = true;
    }

    public String getConfigName() {
        return this.mobInfo.name;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return this.getFullName();
    }

    public String getFullName() {
        String name = "";
        if (!"".equals(this.getAgeName())) {
            name = name + this.getAgeName() + " ";
        }
        if (!"".equals(this.getSubspeciesTitle())) {
            name = name + this.getSubspeciesTitle() + " ";
        }
        return name + this.getSpeciesName();
    }

    public String getSpeciesName() {
        if (this.mobInfo == null) {
            return super.func_70005_c_();
        }
        String entityName = this.mobInfo.name;
        return I18n.func_74838_a((String)("entity." + this.mobInfo.group.filename + "." + entityName + ".name"));
    }

    public String getSubspeciesTitle() {
        if (this.getSubspecies() != null) {
            return this.getSubspecies().getTitle();
        }
        return "";
    }

    public String getAgeName() {
        return "";
    }

    public byte getByteFromDataManager(DataParameter<Byte> key) {
        try {
            return (Byte)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getIntFromDataManager(DataParameter<Integer> key) {
        try {
            return (Integer)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public float getFloatFromDataManager(DataParameter<Float> key) {
        try {
            return ((Float)this.func_184212_Q().func_187225_a(key)).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public String getStringFromDataManager(DataParameter<String> key) {
        try {
            return (String)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ItemStack getItemStackFromDataManager(DataParameter<ItemStack> key) {
        try {
            return (ItemStack)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return ItemStack.field_190927_a;
        }
    }

    public Optional<BlockPos> getBlockPosFromDataManager(DataParameter<Optional<BlockPos>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    public boolean func_70601_bi() {
        return this.spawnCheck(this.func_130014_f_(), this.func_180425_c());
    }

    public int func_70641_bl() {
        return this.mobInfo.spawnInfo.spawnGroupMax;
    }

    public boolean spawnCheck(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return false;
        }
        LycanitesMobs.printDebug("MobSpawns", " ~O==================== Spawn Check: " + this.getConfigName() + " ====================O~");
        LycanitesMobs.printDebug("MobSpawns", "Attempting to Spawn: " + this.getConfigName());
        LycanitesMobs.printDebug("MobSpawns", "Checking for peaceful difficulty...");
        if (!this.mobInfo.peacefulDifficulty && this.func_130014_f_().func_175659_aa() == EnumDifficulty.PEACEFUL) {
            return false;
        }
        LycanitesMobs.printDebug("MobSpawns", "Target Spawn Location: " + pos);
        LycanitesMobs.printDebug("MobSpawns", "Fixed spawn check (light level, obstacles, etc)...");
        if (!this.fixedSpawnCheck(world, pos)) {
            return false;
        }
        LycanitesMobs.printDebug("MobSpawns", "Checking for nearby spawner...");
        if (this.isSpawnerNearby(world, pos)) {
            LycanitesMobs.printDebug("MobSpawns", "Spawner found, skipping other checks.");
            LycanitesMobs.printDebug("MobSpawns", "Spawn Check Passed!");
            return true;
        }
        LycanitesMobs.printDebug("MobSpawns", "No spawner found.");
        LycanitesMobs.printDebug("MobSpawns", "Natural spawn check (dimension, area limit, ground type, water, lava, underground)...");
        if (!this.naturalSpawnCheck(world, pos)) {
            return false;
        }
        LycanitesMobs.printDebug("MobSpawns", "All enviroment checks passed.");
        if (this.mobInfo.spawnInfo.spawnChance < 1.0) {
            if (this.mobInfo.spawnInfo.spawnChance <= 0.0) {
                LycanitesMobs.printDebug("MobSpawns", "Applying Forced Spawn Chance - Chance is 0 = No Spawning");
                return false;
            }
            double spawnRoll = this.field_70146_Z.nextDouble();
            LycanitesMobs.printDebug("MobSpawns", "Applying Forced Spawn Chance - Rolled: " + spawnRoll + " Must be less than: " + this.mobInfo.spawnInfo.spawnChance);
            if (spawnRoll > this.mobInfo.spawnInfo.spawnChance) {
                return false;
            }
        }
        LycanitesMobs.printDebug("MobSpawns", "Spawn Check Passed!");
        return true;
    }

    public boolean fixedSpawnCheck(World world, BlockPos pos) {
        if (this.spawnedFromType == null || this.spawnedFromType != null && !this.spawnedFromType.ignoreLight) {
            byte light = this.testLightLevel(pos);
            boolean validLight = false;
            Block spawnBlock = world.func_180495_p(pos).func_177230_c();
            LycanitesMobs.printDebug("MobSpawns", "Checking light level: Darkness");
            if (this.mobInfo.spawnInfo.spawnsInDark && light <= 1) {
                validLight = true;
            }
            LycanitesMobs.printDebug("MobSpawns", "Checking light level: Lightness");
            if (this.mobInfo.spawnInfo.spawnsInLight && light >= 2) {
                validLight = true;
            }
            if (!validLight) {
                return false;
            }
        }
        LycanitesMobs.printDebug("MobSpawns", "Checking entity collision.");
        if (!this.func_130014_f_().func_72855_b(this.func_174813_aQ())) {
            return false;
        }
        LycanitesMobs.printDebug("MobSpawns", "Checking solid block collision.");
        return this.spawnsInBlock || this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
    }

    public boolean naturalSpawnCheck(World world, BlockPos pos) {
        if (this.mobInfo.spawnInfo.spawnMinDay > 0) {
            int currentDay = (int)Math.floor((double)world.func_82737_E() / 24000.0);
            LycanitesMobs.printDebug("MobSpawns", "Checking world age, currently on day: " + currentDay + ", must be at least day: " + this.mobInfo.spawnInfo.spawnMinDay + ".");
            if (currentDay < this.mobInfo.spawnInfo.spawnMinDay) {
                return false;
            }
        }
        LycanitesMobs.printDebug("MobSpawns", "Checking dimension.");
        if (!this.isNativeDimension(this.func_130014_f_())) {
            return false;
        }
        LycanitesMobs.printDebug("MobSpawns", "Block preference.");
        if (this.getBlockPathWeight(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) < 0.0f && this.spawnedFromType == null) {
            return false;
        }
        LycanitesMobs.printDebug("MobSpawns", "Checking for liquid (water, lava, ooze, etc).");
        if (!this.spawnsInWater && this.func_130014_f_().func_72953_d(this.func_174813_aQ())) {
            return false;
        }
        if (!this.spawnsOnLand && !this.func_130014_f_().func_72953_d(this.func_174813_aQ())) {
            return false;
        }
        LycanitesMobs.printDebug("MobSpawns", "Checking for underground.");
        if (!this.spawnsUnderground && this.isBlockUnderground(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p())) {
            return false;
        }
        LycanitesMobs.printDebug("MobSpawns", "Checking required blocks.");
        if (!this.spawnBlockCheck(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
            return false;
        }
        LycanitesMobs.printDebug("MobSpawns", "Counting mobs of the same kind, max allowed is: " + this.mobInfo.spawnInfo.spawnAreaLimit);
        if (!this.spawnLimitCheck(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
            return false;
        }
        LycanitesMobs.printDebug("MobSpawns", "Checking for nearby bosses.");
        List<EntityCreatureBase> bosses = this.getNearbyEntities(EntityCreatureBase.class, IGroupBoss.class, SpawnInfo.spawnLimitRange);
        return bosses.size() <= 0;
    }

    public boolean isNativeDimension(World world) {
        if (this.spawnedFromType != null && this.spawnedFromType.ignoreDimension) {
            LycanitesMobs.printDebug("MobSpawns", "Dimension check is ignored by " + this.spawnedFromType.typeName + " spawn type.");
            return true;
        }
        if (world == null || world.field_73011_w == null || this.mobInfo == null || this.mobInfo.spawnInfo == null || this.mobInfo.spawnInfo.dimensionTypes == null) {
            LycanitesMobs.printDebug("MobSpawns", "No dimension spawn settings were found for this mob, defaulting to valid.");
            return true;
        }
        for (String spawnDimensionType : this.mobInfo.spawnInfo.dimensionTypes) {
            if ("ALL".equalsIgnoreCase(spawnDimensionType)) {
                LycanitesMobs.printDebug("MobSpawns", "All dimensions allowed.");
                return true;
            }
            if ("VANILLA".equalsIgnoreCase(spawnDimensionType)) {
                LycanitesMobs.printDebug("MobSpawns", "Vanilla only: Overworld, Nether and End.");
                return world.field_73011_w.getDimension() > -2 && world.field_73011_w.getDimension() < 2;
            }
            if (!"GROUP".equalsIgnoreCase(spawnDimensionType)) continue;
            for (String groupSpawnDimensionType : this.mobInfo.group.dimensionTypes) {
                if ("ALL".equalsIgnoreCase(groupSpawnDimensionType)) {
                    LycanitesMobs.printDebug("MobSpawns", "All dimensions allowed by group.");
                    return true;
                }
                if (!"VANILLA".equalsIgnoreCase(groupSpawnDimensionType)) continue;
                LycanitesMobs.printDebug("MobSpawns", "Vanilla only by group: Overworld, Nether and End.");
                if (world.field_73011_w.getDimension() > -2 && world.field_73011_w.getDimension() < 2) {
                    return this.mobInfo.group.dimensionWhitelist;
                }
                return !this.mobInfo.group.dimensionWhitelist;
            }
            for (int spawnDimension : this.mobInfo.group.dimensionBlacklist) {
                if (world.field_73011_w.getDimension() != spawnDimension) continue;
                LycanitesMobs.printDebug("MobSpawns", "Dimension is in group " + (this.mobInfo.group.dimensionWhitelist ? "whitelist, allowed" : "blacklist, not allowed") + ".");
                return this.mobInfo.group.dimensionWhitelist;
            }
            if (this.mobInfo.spawnInfo.dimensionBlacklist != null && this.mobInfo.spawnInfo.dimensionBlacklist.length != 0) continue;
            LycanitesMobs.printDebug("MobSpawns", "Dimension was not in group " + (this.mobInfo.group.dimensionWhitelist ? "whitelist, not allowed" : "blacklist, allowed") + " and there are no entries in the mob specific black/whitelist.");
            return !this.mobInfo.group.dimensionWhitelist;
        }
        for (int spawnDimension : this.mobInfo.spawnInfo.dimensionBlacklist) {
            if (world.field_73011_w.getDimension() != spawnDimension) continue;
            LycanitesMobs.printDebug("MobSpawns", "Dimension is in " + (this.mobInfo.spawnInfo.dimensionWhitelist ? "whitelist, allowed" : "blacklist, not allowed") + ".");
            return this.mobInfo.spawnInfo.dimensionWhitelist;
        }
        LycanitesMobs.printDebug("MobSpawns", "Dimension was not in " + (this.mobInfo.spawnInfo.dimensionWhitelist ? "whitelist, not allowed" : "blacklist, allowed") + ".");
        return !this.mobInfo.spawnInfo.dimensionWhitelist;
    }

    public boolean spawnLimitCheck(World world, int i, int j, int k) {
        int spawnLimit = this.mobInfo.spawnInfo.spawnAreaLimit;
        double range = SpawnInfo.spawnLimitRange;
        LycanitesMobs.printDebug("MobSpawns", "Checking spawn area limit. Limit of: " + spawnLimit + " Range of: " + range);
        if (spawnLimit > 0 && range > 0.0) {
            List<EntityCreatureBase> targets = this.getNearbyEntities(EntityCreatureBase.class, this.mobInfo.entityClass, range);
            LycanitesMobs.printDebug("MobSpawns", "Found " + targets.size() + " of this mob within the radius (class is " + this.mobInfo.entityClass + ").");
            if (targets.size() >= spawnLimit) {
                return false;
            }
        }
        return true;
    }

    public boolean spawnBlockCheck(World world, int x, int y, int z) {
        if (this.spawnedFromType != null) {
            SpawnInfo cfr_ignored_0 = this.mobInfo.spawnInfo;
            if (SpawnInfo.enforceBlockCost) {
                Block block;
                int k;
                int j;
                int i;
                int blocksFound = 0;
                if (this.spawnedFromType.materials != null) {
                    for (i = x - this.spawnedFromType.range; i <= x + this.spawnedFromType.range; ++i) {
                        for (j = y - this.spawnedFromType.range; j <= y + this.spawnedFromType.range; ++j) {
                            for (k = z - this.spawnedFromType.range; k <= z + this.spawnedFromType.range; ++k) {
                                Material blockMaterial = world.func_180495_p(new BlockPos(i, j, k)).func_185904_a();
                                for (Material material : this.spawnedFromType.materials) {
                                    if (blockMaterial != material || ++blocksFound < this.mobInfo.spawnInfo.spawnBlockCost) continue;
                                    return true;
                                }
                            }
                        }
                    }
                }
                if (this.spawnedFromType.blocks != null) {
                    for (i = x - this.spawnedFromType.range; i <= x + this.spawnedFromType.range; ++i) {
                        for (j = y - this.spawnedFromType.range; j <= y + this.spawnedFromType.range; ++j) {
                            for (k = z - this.spawnedFromType.range; k <= z + this.spawnedFromType.range; ++k) {
                                block = world.func_180495_p(new BlockPos(i, j, k)).func_177230_c();
                                for (Block block2 : this.spawnedFromType.blocks) {
                                    if (block != block2 || ++blocksFound < this.mobInfo.spawnInfo.spawnBlockCost) continue;
                                    return true;
                                }
                            }
                        }
                    }
                }
                if (this.spawnedFromType.blockStrings != null) {
                    for (i = x - this.spawnedFromType.range; i <= x + this.spawnedFromType.range; ++i) {
                        for (j = y - this.spawnedFromType.range; j <= y + this.spawnedFromType.range; ++j) {
                            for (k = z - this.spawnedFromType.range; k <= z + this.spawnedFromType.range; ++k) {
                                block = world.func_180495_p(new BlockPos(i, j, k)).func_177230_c();
                                for (String string : this.spawnedFromType.blockStrings) {
                                    if (block != ObjectManager.getBlock(string) || ++blocksFound < this.mobInfo.spawnInfo.spawnBlockCost) continue;
                                    return true;
                                }
                            }
                        }
                    }
                }
                return false;
            }
        }
        return true;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingData) {
        livingData = super.func_180482_a(difficulty, livingData);
        return livingData;
    }

    protected boolean func_70692_ba() {
        if (this.mobInfo.spawnInfo.despawnForced) {
            return true;
        }
        if (!this.mobInfo.spawnInfo.despawnNatural) {
            return false;
        }
        if (this.forceNoDespawn) {
            return false;
        }
        if (this.boss || this.getSubspeciesIndex() >= 3) {
            return false;
        }
        if (this.isPersistant() || this.func_110167_bD() || this.func_145818_k_() && "".equals(this.spawnEventType)) {
            return false;
        }
        return super.func_70692_ba();
    }

    public boolean isPersistant() {
        return false;
    }

    public boolean despawnCheck() {
        if (this.func_130014_f_().field_72995_K) {
            return false;
        }
        if (!this.mobInfo.mobEnabled) {
            return true;
        }
        if (this.isTemporary && this.temporaryDuration-- <= 0) {
            return true;
        }
        if (this.func_110167_bD() || this.isPersistant()) {
            this.spawnEventType = "";
            this.spawnEventCount = -1;
        } else {
            if (!this.mobInfo.peacefulDifficulty && this.func_130014_f_().func_175659_aa() == EnumDifficulty.PEACEFUL && !this.func_145818_k_()) {
                return true;
            }
            ExtendedWorld worldExt = ExtendedWorld.getForWorld(this.func_130014_f_());
            if (worldExt != null && !"".equals(this.spawnEventType) && this.spawnEventCount >= 0 && this.spawnEventCount != worldExt.getWorldEventCount()) {
                return true;
            }
        }
        return false;
    }

    public boolean isSpawnerNearby(World world, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (world == null) {
            return false;
        }
        int checkRange = 8;
        for (int i = x - checkRange; i <= x + checkRange; ++i) {
            for (int j = y - checkRange; j <= y + checkRange; ++j) {
                for (int k = z - checkRange; k <= z + checkRange; ++k) {
                    TileEntity tileEntity;
                    IBlockState spawnerBlock = world.func_180495_p(new BlockPos(i, j, k));
                    if (spawnerBlock == null || (tileEntity = world.func_175625_s(new BlockPos(i, j, k))) == null || !(tileEntity instanceof TileEntityMobSpawner)) continue;
                    try {
                        String mobSpawnerMobName;
                        NBTTagCompound spawnData;
                        TileEntityMobSpawner mobSpawner = (TileEntityMobSpawner)tileEntity;
                        NBTTagCompound nbt = new NBTTagCompound();
                        mobSpawner.func_145881_a().func_189530_b(nbt);
                        if (!nbt.func_74764_b("SpawnData") || !(spawnData = nbt.func_74775_l("SpawnData")).func_74764_b("id") || !(mobSpawnerMobName = spawnData.func_74779_i("id")).equalsIgnoreCase(this.func_70005_c_())) continue;
                        return true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return false;
    }

    public boolean isBlockUnderground(int x, int y, int z) {
        if (this.func_130014_f_().func_175710_j(new BlockPos(x, y, z))) {
            return false;
        }
        for (int j = y; j < this.func_130014_f_().func_72800_K(); ++j) {
            Material blockMaterial = this.func_130014_f_().func_180495_p(new BlockPos(x, j, z)).func_185904_a();
            if (blockMaterial == Material.field_151579_a || blockMaterial == Material.field_151584_j || blockMaterial == Material.field_151585_k || blockMaterial == Material.field_151577_b || blockMaterial == Material.field_151582_l) continue;
            return true;
        }
        return false;
    }

    public boolean isBoss() {
        return this.boss;
    }

    public boolean func_184222_aU() {
        return !this.isBoss();
    }

    public void createBossInfo(BossInfo.Color color, boolean darkenSky) {
        String name = this.getFullName();
        if (this.isBoss()) {
            name = name + " (Phase " + (this.getBattlePhase() + 1) + ")";
        }
        this.bossInfo = (BossInfoServer)new BossInfoServer((ITextComponent)new TextComponentString(name), color, BossInfo.Overlay.PROGRESS).func_186741_a(darkenSky);
    }

    public BossInfo getBossInfo() {
        if (this.bossInfo == null && this.showBossInfo() && !this.func_130014_f_().field_72995_K) {
            if (this.isBoss()) {
                this.createBossInfo(BossInfo.Color.RED, false);
            } else {
                this.createBossInfo(BossInfo.Color.GREEN, false);
            }
        }
        return this.bossInfo;
    }

    public void refreshBossHealthName() {
        if (this.bossInfo != null) {
            String name = this.getFullName();
            name = name + " (Phase " + (this.getBattlePhase() + 1) + ")";
            this.bossInfo.func_186739_a((ITextComponent)new TextComponentString(name));
        }
    }

    public void summonMinion(EntityLivingBase minion, double angle, double distance) {
        double angleRadians = Math.toRadians(angle);
        double x = this.field_70165_t + (((double)this.field_70130_N + distance) * Math.cos(angleRadians) - Math.sin(angleRadians));
        double y = this.field_70163_u + 1.0;
        double z = this.field_70161_v + (((double)this.field_70130_N + distance) * Math.sin(angleRadians) + Math.cos(angleRadians));
        minion.func_70012_b(x, y, z, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
        if (minion instanceof EntityCreatureBase) {
            ((EntityCreatureBase)minion).setMinion(true);
            ((EntityCreatureBase)minion).setSubspecies(this.getSubspeciesIndex(), true);
            ((EntityCreatureBase)minion).setMasterTarget((EntityLivingBase)this);
            ((EntityCreatureBase)minion).spawnEventType = this.spawnEventType;
        }
        this.func_130014_f_().func_72838_d((Entity)minion);
        if (this.func_70638_az() != null) {
            minion.func_70604_c(this.func_70638_az());
        }
    }

    public void onMinionUpdate(EntityLivingBase minion, long tick) {
    }

    public void onMinionDeath(EntityLivingBase minion) {
    }

    public void setMinion(boolean minion) {
        this.isMinion = minion;
    }

    public boolean isMinion() {
        return this.isMinion;
    }

    public void setTemporary(int duration) {
        this.temporaryDuration = duration;
        this.isTemporary = true;
    }

    public void unsetTemporary() {
        this.isTemporary = false;
        this.temporaryDuration = 0;
    }

    public boolean isBoundPet() {
        return this.hasPetEntry();
    }

    public boolean hasPetEntry() {
        return this.getPetEntry() != null;
    }

    public PetEntry getPetEntry() {
        return this.petEntry;
    }

    public void setPetEntry(PetEntry petEntry) {
        this.petEntry = petEntry;
    }

    public boolean isPetType(String type) {
        if (!this.hasPetEntry()) {
            return false;
        }
        return type.equals(this.getPetEntry().getType());
    }

    public void onFirstSpawn() {
        if (this.hasPetEntry() || this.isMinion()) {
            return;
        }
        if (MobInfo.subspeciesSpawn && !this.mobInfo.spawnInfo.disableSubspecies) {
            this.getRandomSubspecies();
        }
        if (MobInfo.randomSizes) {
            this.getRandomSize();
        }
    }

    public void getRandomSubspecies() {
        if (this.subspecies == null && !this.isMinion()) {
            this.subspecies = this.mobInfo.getRandomSubspecies((EntityLivingBase)this, this.spawnedRare);
            this.applySubspeciesHealthMultiplier();
            if (this.subspecies != null) {
                LycanitesMobs.printDebug("Subspecies", "Setting " + this.getSpeciesName() + " to " + this.subspecies.getTitle());
            } else {
                LycanitesMobs.printDebug("Subspecies", "Setting " + this.getSpeciesName() + " to base species.");
            }
        }
    }

    public void getRandomSize() {
        this.setSizeScale(1.0 + 0.35 * (0.5 - this.func_70681_au().nextDouble()));
    }

    public double getBaseHealth() {
        if (baseHealthMap.containsKey(((Object)((Object)this)).getClass())) {
            return baseHealthMap.get(((Object)((Object)this)).getClass()) * this.getHealthMultiplier() + (double)this.getHealthBoost();
        }
        return 10.0;
    }

    public void applySubspeciesHealthMultiplier() {
        if (this.getSubspeciesIndex() < 1) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseHealth());
            this.func_70606_j((float)this.getBaseHealth());
        } else if (this.getSubspeciesIndex() < 3) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseHealth() * Subspecies.uncommonHealthScale);
            this.func_70606_j((float)(this.getBaseHealth() * Subspecies.uncommonHealthScale));
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseHealth() * Subspecies.rareHealthScale);
            this.func_70606_j((float)(this.getBaseHealth() * Subspecies.rareHealthScale));
        }
    }

    public double getDifficultyMultiplier(String stat) {
        if (this.func_130014_f_() == null || this.func_130014_f_().func_175659_aa() == null) {
            return MobInfo.difficultyMutlipliers.get("NORMAL-" + stat.toUpperCase());
        }
        EnumDifficulty difficulty = this.func_130014_f_().func_175659_aa();
        String difficultyName = "Easy";
        if (difficulty.func_151525_a() >= 3) {
            difficultyName = "Hard";
        } else if (difficulty == EnumDifficulty.NORMAL) {
            difficultyName = "Normal";
        }
        return MobInfo.difficultyMutlipliers.get(difficultyName.toUpperCase() + "-" + stat.toUpperCase());
    }

    public double getAltarMultiplier(String stat) {
        return AltarInfo.rareSubspeciesMutlipliers.get(stat.toUpperCase());
    }

    public double getHealthMultiplier() {
        double multiplier = this.mobInfo.multiplierHealth * this.getDifficultyMultiplier("health");
        if (this.altarSummoned) {
            multiplier *= this.getAltarMultiplier("health");
        }
        if (this.extraMobBehaviour != null) {
            multiplier *= this.extraMobBehaviour.multiplierHealth;
        }
        return multiplier;
    }

    public int getHealthBoost() {
        int boost = this.mobInfo.boostHealth;
        if (this.extraMobBehaviour != null) {
            boost += this.extraMobBehaviour.boostHealth;
        }
        return boost;
    }

    public double getDefenseMultiplier() {
        double multiplier = this.mobInfo.multiplierDefense * this.getDifficultyMultiplier("defense");
        if (this.altarSummoned) {
            multiplier *= this.getAltarMultiplier("defense");
        }
        if (this.extraMobBehaviour != null) {
            multiplier *= this.extraMobBehaviour.multiplierDefense;
        }
        return multiplier;
    }

    public int getDefenseBoost() {
        int boost = this.mobInfo.boostDefense;
        if (this.extraMobBehaviour != null) {
            boost += this.extraMobBehaviour.boostDefense;
        }
        return boost;
    }

    public double getSpeedMultiplier() {
        double multiplier = this.mobInfo.multiplierSpeed * this.getDifficultyMultiplier("speed");
        if (this.altarSummoned) {
            multiplier *= this.getAltarMultiplier("speed");
        }
        if (this.extraMobBehaviour != null) {
            multiplier *= this.extraMobBehaviour.multiplierSpeed;
        }
        return multiplier;
    }

    public float getSpeedBoost() {
        int boost = this.mobInfo.boostSpeed / 100;
        if (this.extraMobBehaviour != null) {
            boost += this.extraMobBehaviour.boostSpeed;
        }
        return boost;
    }

    public double getDamageMultiplier() {
        double multiplier = this.mobInfo.multiplierDamage * this.getDifficultyMultiplier("damage");
        if (this.altarSummoned) {
            multiplier *= this.getAltarMultiplier("damage");
        }
        if (this.extraMobBehaviour != null) {
            multiplier *= this.extraMobBehaviour.multiplierDamage;
        }
        return multiplier;
    }

    public int getDamageBoost() {
        int boost = this.mobInfo.boostDamage;
        if (this.extraMobBehaviour != null) {
            boost += this.extraMobBehaviour.boostDamage;
        }
        return boost;
    }

    public double getHasteMultiplier() {
        double multiplier = this.mobInfo.multiplierHaste * this.getDifficultyMultiplier("haste");
        if (this.altarSummoned) {
            multiplier *= this.getAltarMultiplier("haste");
        }
        if (this.extraMobBehaviour != null) {
            multiplier *= this.extraMobBehaviour.multiplierHaste;
        }
        return multiplier;
    }

    public int getHasteBoost() {
        int boost = this.mobInfo.boostHaste;
        if (this.extraMobBehaviour != null) {
            boost += this.extraMobBehaviour.boostHaste;
        }
        return boost;
    }

    public int getHaste(int ticks) {
        ticks -= this.getHasteBoost();
        double ticksScale = 1.0 / this.getHasteMultiplier();
        ticks = Math.round((float)ticks * (float)ticksScale);
        return Math.max(0, ticks);
    }

    public double getEffectMultiplier() {
        double multiplier = this.mobInfo.multiplierEffect * this.getDifficultyMultiplier("effect");
        if (this.altarSummoned) {
            multiplier *= this.getAltarMultiplier("effect");
        }
        if (this.extraMobBehaviour != null) {
            multiplier *= this.extraMobBehaviour.multiplierEffect;
        }
        return multiplier;
    }

    public int getEffectBoost() {
        int boost = this.mobInfo.boostEffect;
        if (this.extraMobBehaviour != null) {
            boost += this.extraMobBehaviour.boostEffect;
        }
        return boost;
    }

    public int getEffectDuration(int seconds) {
        return Math.round((float)seconds * (float)this.getEffectMultiplier() * 20.0f) + this.getEffectBoost();
    }

    public float getEffectStrength(float value) {
        return Math.round(value * (float)this.getEffectMultiplier()) + this.getEffectBoost();
    }

    public double getPierceMultiplier() {
        double multiplier = this.mobInfo.multiplierPierce * this.getDifficultyMultiplier("pierce");
        if (this.altarSummoned) {
            multiplier *= this.getAltarMultiplier("pierce");
        }
        if (this.extraMobBehaviour != null) {
            multiplier *= this.extraMobBehaviour.multiplierPierce;
        }
        return multiplier;
    }

    public double getPierceBoost() {
        int boost = this.mobInfo.boostPierce;
        if (this.extraMobBehaviour != null) {
            boost += this.extraMobBehaviour.boostPierce;
        }
        return boost;
    }

    public double getPierceBase() {
        return 5.0;
    }

    public double getPierceValue() {
        if (this.getPierceMultiplier() == 0.0) {
            return 100.0;
        }
        double value = this.getPierceBase();
        value *= 1.0 / this.getPierceMultiplier();
        return Math.max(1.0, value -= Math.max(0.0, this.getPierceBoost()));
    }

    public void updateBattlePhase() {
    }

    public int getBattlePhase() {
        return this.battlePhase;
    }

    public void setBattlePhase(int phase) {
        if (this.getBattlePhase() == phase) {
            return;
        }
        this.battlePhase = phase;
        this.refreshBossHealthName();
        this.playPhaseSound();
    }

    public void setSubspecies(int subspeciesIndex, boolean resetHealth) {
        this.subspecies = this.mobInfo.getSubspecies(subspeciesIndex);
        float scaledExp = this.experience;
        if (subspeciesIndex == 1 || subspeciesIndex == 2) {
            scaledExp = Math.round((float)((double)this.experience * Subspecies.uncommonExperienceScale));
        } else if (subspeciesIndex >= 3) {
            scaledExp = Math.round((float)((double)this.experience * Subspecies.rareExperienceScale));
        }
        this.field_70728_aV = Math.round(scaledExp);
        if (resetHealth) {
            this.applySubspeciesHealthMultiplier();
        }
        this.refreshBossHealthName();
    }

    public Subspecies getSubspecies() {
        return this.subspecies;
    }

    public int getSubspeciesIndex() {
        return this.getSubspecies() != null ? this.getSubspecies().index : 0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70180_af != null) {
            this.onSyncUpdate();
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.updateHitAreas();
        }
        if (this.despawnCheck()) {
            if (!this.isBoundPet()) {
                this.inventory.dropInventory();
            }
            this.func_70106_y();
        }
        boolean bl = this.field_70178_ae = !this.canBurn();
        if (!this.canWalk() && !this.isFlying() && !this.func_70090_H() && this.isMoving() || !this.canMove()) {
            this.clearMovement();
        }
        if (!this.func_130014_f_().field_72995_K || this.func_184186_bw()) {
            this.setBesideClimbableBlock(this.field_70123_F);
            if (!this.field_70122_E && this.flySoundSpeed > 0 && this.field_70173_aa % 20 == 0) {
                this.playFlySound();
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.isFlying() && this.hasAttackTarget() && this.updateTick % 40L == 0L) {
            this.leap(0.0, 0.4);
        }
        if (!this.func_130014_f_().field_72995_K && this.guiViewers.size() <= 0) {
            this.guiRefreshTick = 0;
        }
        if (!this.func_130014_f_().field_72995_K && this.guiRefreshTick > 0 && --this.guiRefreshTick <= 0) {
            this.refreshGUIViewers();
            this.guiRefreshTick = 0;
        }
        if (this.bossInfo != null) {
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
    }

    protected void func_70619_bc() {
        if (this.useDirectNavigator()) {
            this.directNavigator.updateFlight();
        }
        super.func_70619_bc();
    }

    public void func_70636_d() {
        float brightness;
        super.func_70636_d();
        this.updateBattlePhase();
        this.func_82168_bl();
        if (!this.func_130014_f_().field_72995_K && this.firstSpawn) {
            this.onFirstSpawn();
            this.firstSpawn = false;
        }
        if (this.hasAttackTarget() && this.func_70638_az() instanceof EntityPlayer) {
            EntityPlayer targetPlayer = (EntityPlayer)this.func_70638_az();
            if (targetPlayer.field_71075_bZ.field_75098_d) {
                this.func_70624_b(null);
            }
        }
        if (this.hasAvoidTarget() && this.currentFleeTime-- <= 0) {
            this.setAvoidTarget(null);
        }
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= this.getFallingMod();
        }
        if (!this.func_130014_f_().field_72995_K && this.daylightBurns() && this.func_130014_f_().func_72935_r() && (brightness = this.func_70013_c(1.0f)) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (brightness - 0.4f) * 2.0f && this.func_130014_f_().func_175710_j(this.func_180425_c())) {
            boolean shouldBurn = true;
            ItemStack helmet = this.inventory.getEquipmentStack("head");
            if (helmet != null) {
                if (helmet.func_77984_f()) {
                    helmet.func_77964_b(helmet.func_77952_i() + this.field_70146_Z.nextInt(2));
                    if (helmet.func_77952_i() >= helmet.func_77958_k()) {
                        this.func_70669_a(helmet);
                        this.setCurrentItemOrArmor(4, null);
                    }
                }
                shouldBurn = false;
            }
            if (shouldBurn) {
                this.func_70015_d(8);
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.waterDamage() && this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (!this.func_130014_f_().field_72995_K && !this.canBreatheAboveWater()) {
            int currentAir = this.func_70086_ai();
            if (this.func_70089_S()) {
                if (!this.isLavaCreature && !this.waterContact() || this.isLavaCreature && !this.lavaContact()) {
                    this.func_70050_g(--currentAir);
                    if (this.func_70086_ai() <= -200) {
                        this.func_70050_g(-180);
                        this.func_70097_a(DamageSource.field_76369_e, 2.0f);
                    }
                } else {
                    this.func_70050_g(299);
                }
            }
        }
        float light = this.func_70013_c(1.0f);
        if (!this.mobInfo.spawnInfo.spawnsInLight && light > 0.5f) {
            this.field_70708_bq += 2;
        }
        if (!this.func_130014_f_().field_72995_K) {
            if (this.isStealthed() && !this.func_82150_aj()) {
                this.func_82142_c(true);
            } else if (!this.isStealthed() && this.func_82150_aj() && !this.func_70644_a(MobEffects.field_76441_p)) {
                this.func_82142_c(false);
            }
        }
        if (this.isStealthed()) {
            if (this.stealthPrev != this.isStealthed()) {
                this.startStealth();
            }
            this.onStealth();
        } else if (this.func_82150_aj() && !this.func_70644_a(MobEffects.field_76441_p) && !this.func_130014_f_().field_72995_K) {
            this.func_82142_c(false);
        }
        this.stealthPrev = this.isStealthed();
        if (this.currentBlockingTime > 0) {
            --this.currentBlockingTime;
        }
        if (this.currentBlockingTime < 0) {
            this.currentBlockingTime = 0;
        }
        if (this.field_70173_aa % 20 == 0 && !this.func_130014_f_().field_72995_K && this.func_70089_S() && this.canPickupItems()) {
            this.pickupItems();
        }
        if (!this.func_130014_f_().field_72995_K && this.pickupEntity != null) {
            if (!this.pickupEntity.func_70089_S()) {
                this.dropPickupEntity();
            } else if (Math.sqrt(this.func_70068_e((Entity)this.pickupEntity)) > 32.0) {
                this.dropPickupEntity();
            }
        }
        this.getBossInfo();
        if (this.getMasterTarget() != null && this.getMasterTarget() instanceof EntityCreatureBase) {
            ((EntityCreatureBase)this.getMasterTarget()).onMinionUpdate((EntityLivingBase)this, this.updateTick);
        }
        ++this.updateTick;
    }

    public void onSyncUpdate() {
        byte animations;
        if (!this.func_130014_f_().field_72995_K) {
            byte targets = 0;
            if (this.func_70638_az() != null) {
                targets = (byte)(targets + TARGET_ID.ATTACK.id);
            }
            if (this.getMasterTarget() != null) {
                targets = (byte)(targets + TARGET_ID.MASTER.id);
            }
            if (this.getParentTarget() != null) {
                targets = (byte)(targets + TARGET_ID.PARENT.id);
            }
            if (this.getAvoidTarget() != null) {
                targets = (byte)(targets + TARGET_ID.AVOID.id);
            }
            if (this.func_184179_bs() != null) {
                targets = (byte)(targets + TARGET_ID.RIDER.id);
            }
            this.field_70180_af.func_187227_b(TARGET, (Object)targets);
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(ATTACK_PHASE, (Object)this.attackPhase);
        }
        if (!this.func_130014_f_().field_72995_K) {
            animations = 0;
            if (this.justAttacked == this.justAttackedTime) {
                animations = (byte)(animations + ANIM_ID.ATTACKED.id);
                this.justAttacked = 0;
                this.playAttackSound();
            }
            if (this.field_70122_E) {
                animations = (byte)(animations + ANIM_ID.GROUNDED.id);
            }
            if (this.field_70171_ac) {
                animations = (byte)(animations + ANIM_ID.IN_WATER.id);
            }
            if (this.isBlocking()) {
                animations = (byte)(animations + ANIM_ID.BLOCKING.id);
            }
            if (this.isMinion()) {
                animations = (byte)(animations + ANIM_ID.MINION.id);
            }
            if (this.extraAnimation01()) {
                animations = (byte)(animations + ANIM_ID.EXTRA01.id);
            }
            this.field_70180_af.func_187227_b(ANIMATION, (Object)animations);
        } else if (this.func_130014_f_().field_72995_K) {
            animations = this.getByteFromDataManager(ANIMATION);
            if (this.justAttacked > 0) {
                this.justAttacked = (short)(this.justAttacked - 1);
            } else if ((animations & ANIM_ID.ATTACKED.id) > 0) {
                this.setJustAttacked();
            }
            this.field_70122_E = (animations & ANIM_ID.GROUNDED.id) > 0;
            this.field_70171_ac = (animations & ANIM_ID.IN_WATER.id) > 0;
            boolean bl = this.extraAnimation01 = (animations & ANIM_ID.EXTRA01.id) > 0;
        }
        if (this.func_130014_f_().field_72995_K) {
            boolean bl = this.isMinion = (this.getByteFromDataManager(ANIMATION) & ANIM_ID.MINION.id) > 0;
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(SUBSPECIES, (Object)((byte)this.getSubspeciesIndex()));
        } else if (this.getSubspeciesIndex() != this.getByteFromDataManager(SUBSPECIES)) {
            this.setSubspecies(this.getByteFromDataManager(SUBSPECIES), false);
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf((float)this.sizeScale));
        } else if (this.sizeScale != (double)this.getFloatFromDataManager(SIZE)) {
            this.sizeScale = this.getFloatFromDataManager(SIZE);
            this.updateSize();
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(ARENA, (Object)(this.getArenaCenter() != null ? Optional.of((Object)this.getArenaCenter()) : Optional.absent()));
        }
    }

    public void updateHitAreas() {
        if (!ENABLE_HITAREAS.booleanValue()) {
            return;
        }
        int hitAreaWidthCount = Math.max(1, Math.round(this.field_70130_N * this.hitAreaWidthScale / 4.0f));
        int hitAreaHeightCount = Math.max(1, Math.round(this.field_70131_O * this.hitAreaHeightScale / 4.0f));
        if (hitAreaWidthCount < 2 && hitAreaHeightCount < 2) {
            this.hitAreas = null;
            return;
        }
        if (this.hitAreas == null || this.hitAreas[0] == null || this.hitAreas[0][0] == null || this.hitAreas.length != hitAreaHeightCount || this.hitAreas[0].length != hitAreaWidthCount || this.hitAreas[0][0].length != hitAreaWidthCount) {
            this.hitAreas = new EntityHitArea[hitAreaHeightCount][hitAreaWidthCount][hitAreaWidthCount];
        }
        for (int y = 0; y < hitAreaHeightCount; ++y) {
            for (int x = 0; x < hitAreaWidthCount; ++x) {
                for (int z = 0; z < hitAreaWidthCount; ++z) {
                    if (y != 0 && y != hitAreaHeightCount - 1 && x != 0 && x != hitAreaWidthCount - 1 && z != 0 && z != hitAreaWidthCount - 1) continue;
                    if (this.hitAreas[y][x][z] == null) {
                        this.hitAreas[y][x][z] = new EntityHitArea((Entity)this, this.field_70130_N / (float)hitAreaWidthCount * this.hitAreaWidthScale, this.field_70131_O / (float)hitAreaHeightCount * this.hitAreaHeightScale);
                        this.func_130014_f_().func_72838_d((Entity)this.hitAreas[y][x][z]);
                    }
                    this.hitAreas[y][x][z].field_70165_t = this.field_70165_t - (double)(this.field_70130_N * this.hitAreaWidthScale / 2.0f) + (double)(this.field_70130_N * this.hitAreaWidthScale / (float)hitAreaWidthCount / 2.0f) + (double)(this.field_70130_N * this.hitAreaWidthScale / (float)hitAreaWidthCount * (float)x);
                    this.hitAreas[y][x][z].field_70163_u = this.field_70163_u + (double)(this.field_70131_O / (float)hitAreaHeightCount * this.hitAreaHeightScale * (float)y);
                    this.hitAreas[y][x][z].field_70161_v = this.field_70161_v - (double)(this.field_70130_N * this.hitAreaWidthScale / 2.0f) + (double)(this.field_70130_N * this.hitAreaWidthScale / (float)hitAreaWidthCount / 2.0f) + (double)(this.field_70130_N * this.hitAreaWidthScale / (float)hitAreaWidthCount * (float)z);
                    this.hitAreas[y][x][z].field_70177_z = this.field_70177_z;
                }
            }
        }
    }

    public AxisAlignedBB func_70046_E() {
        if (this.solidCollision) {
            return this.func_174813_aQ();
        }
        return null;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return super.func_70114_g(entity);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ();
    }

    public float getBlockPathWeight(int par1, int par2, int par3) {
        if (this.mobInfo.spawnInfo.spawnsInDark && !this.mobInfo.spawnInfo.spawnsInLight) {
            return 0.5f - this.func_130014_f_().func_175724_o(new BlockPos(par1, par2, par3));
        }
        if (this.mobInfo.spawnInfo.spawnsInLight && !this.mobInfo.spawnInfo.spawnsInDark) {
            return this.func_130014_f_().func_175724_o(new BlockPos(par1, par2, par3)) - 0.5f;
        }
        return 0.0f;
    }

    public boolean useDirectNavigator() {
        return false;
    }

    public boolean shouldSwim() {
        if (!this.func_70090_H() && !this.func_180799_ab()) {
            return false;
        }
        if (this.canWade() && this.func_70648_aU()) {
            IBlockState blockState;
            boolean targetInWater = true;
            if (this.func_70638_az() != null) {
                targetInWater = this.func_70638_az().func_70090_H();
            } else if (this.getParentTarget() != null) {
                targetInWater = this.getParentTarget().func_70090_H();
            } else if (this.getMasterTarget() != null) {
                targetInWater = this.getMasterTarget().func_70090_H();
            }
            return targetInWater || (blockState = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177984_a())) != null && !blockState.func_177230_c().isAir(blockState, (IBlockAccess)this.func_130014_f_(), this.func_180425_c().func_177984_a());
        }
        return this.isStrongSwimmer();
    }

    public void func_70612_e(float moveStrafe, float moveForward) {
        if (!this.useDirectNavigator()) {
            if (this.isFlying() && !this.func_70090_H() && !this.func_180799_ab()) {
                this.moveFlyingWithHeading(moveStrafe, moveForward);
                this.updateLimbSwing();
            } else if (this.shouldSwim()) {
                this.moveSwimmingWithHeading(moveStrafe, moveForward);
                this.updateLimbSwing();
            } else {
                super.func_70612_e(moveStrafe, moveForward);
            }
        } else {
            this.directNavigator.flightMovement(moveStrafe, moveForward);
            this.updateLimbSwing();
        }
    }

    public void updateLimbSwing() {
        this.field_184618_aE = this.field_70721_aZ;
        double distanceX = this.field_70165_t - this.field_70169_q;
        double distanceZ = this.field_70161_v - this.field_70166_s;
        float distance = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ)) * 4.0f;
        if (distance > 1.0f) {
            distance = 1.0f;
        }
        this.field_70721_aZ += (distance - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public void moveFlyingWithHeading(float strafe, float forward) {
        float f = 0.91f;
        if (this.field_70122_E) {
            f = this.func_130014_f_().func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
        }
        float f1 = 0.16277136f / (f * f * f);
        this.moveFlying(strafe, forward, this.field_70122_E ? 0.1f * f1 : 0.02f);
        f = 0.91f;
        if (this.field_70122_E) {
            f = this.func_130014_f_().func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)f;
        this.field_70181_x *= (double)f;
        this.field_70179_y *= (double)f;
        this.field_184618_aE = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public void moveFlying(float strafe, float forward, float friction) {
        if (!this.func_96092_aw() && this.canWalk() && this.func_70090_H()) {
            float sliperryness = 0.91f;
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185345_c((double)this.field_70165_t, (double)(this.func_174813_aQ().field_72338_b - 1.0), (double)this.field_70161_v);
            if (this.field_70122_E) {
                sliperryness = this.func_130014_f_().func_180495_p((BlockPos)blockpos$pooledmutableblockpos).func_177230_c().field_149765_K * sliperryness * 2.0f;
            }
            float f7 = 0.16277136f / (sliperryness * sliperryness * sliperryness);
            friction = this.func_70689_ay() * f7;
        }
    }

    public void moveSwimmingWithHeading(float strafe, float forward) {
        this.func_70060_a(strafe, forward, 0.1f);
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)0.9f;
        this.field_70181_x *= (double)0.9f;
        this.field_70179_y *= (double)0.9f;
    }

    protected PathNavigate func_175447_b(World world) {
        return new CreaturePathNavigate(this, world);
    }

    protected EntityMoveHelper createMoveHelper() {
        return new CreatureMoveHelper(this);
    }

    public PathNavigate func_70661_as() {
        return super.func_70661_as();
    }

    public EntityMoveHelper func_70605_aq() {
        return super.func_70605_aq();
    }

    public void clearMovement() {
        if (!this.useDirectNavigator() && this.func_70661_as() != null) {
            this.func_70661_as().func_75499_g();
        } else {
            this.directNavigator.clearTargetPosition(1.0);
        }
    }

    protected void func_110159_bB() {
        super.func_110159_bB();
        if (this.func_110167_bD() && this.func_110166_bE() != null && this.func_110166_bE().func_130014_f_() == this.func_130014_f_()) {
            Entity entity = this.func_110166_bE();
            this.setHome((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, 5.0f);
            float distance = this.func_70032_d(entity);
            this.testLeash(distance);
            if (!this.leashAIActive) {
                this.field_70714_bg.func_75776_a(2, this.leashMoveTowardsRestrictionAI);
                if (!this.isStrongSwimmer()) {
                    this.func_184644_a(PathNodeType.WATER, 0.0f);
                }
                this.leashAIActive = true;
            }
            if (distance > 4.0f) {
                this.func_70661_as().func_75497_a(entity, 1.0);
            }
            if (distance > 6.0f) {
                double d0 = (entity.field_70165_t - this.field_70165_t) / (double)distance;
                double d1 = (entity.field_70163_u - this.field_70163_u) / (double)distance;
                double d2 = (entity.field_70161_v - this.field_70161_v) / (double)distance;
                this.field_70159_w += d0 * Math.abs(d0) * 0.4;
                this.field_70181_x += d1 * Math.abs(d1) * 0.4;
                this.field_70179_y += d2 * Math.abs(d2) * 0.4;
            }
            if (distance > 10.0f) {
                this.func_110160_i(true, true);
            }
        } else if (!this.func_110167_bD() && this.leashAIActive) {
            this.leashAIActive = false;
            this.field_70714_bg.func_85156_a(this.leashMoveTowardsRestrictionAI);
            if (!this.isStrongSwimmer()) {
                this.func_184644_a(PathNodeType.WATER, PathNodeType.WATER.func_186289_a());
            }
            this.detachHome();
        }
    }

    public boolean func_96092_aw() {
        return !this.isStrongSwimmer();
    }

    public boolean isMoving() {
        if (!this.useDirectNavigator()) {
            return this.func_70661_as().func_75505_d() != null;
        }
        return !this.directNavigator.atTargetPosition();
    }

    public boolean func_70104_M() {
        return super.func_70104_M();
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public void testLeash(float distance) {
    }

    public void func_70659_e(float speed) {
        super.func_70659_e((speed + this.getSpeedBoost()) * this.getAISpeedModifier() * (float)this.getSpeedMultiplier());
    }

    public float getAISpeedModifier() {
        return 1.0f;
    }

    public double getFallingMod() {
        return 1.0;
    }

    protected float func_189749_co() {
        if (!this.func_96092_aw()) {
            return 1.0f;
        }
        return 0.8f;
    }

    public void leap(double distance, double leapHeight) {
        double angle = Math.toRadians(this.field_70177_z);
        double xAmount = -Math.sin(angle);
        double yAmount = leapHeight;
        double zAmount = Math.cos(angle);
        if (this.isFlying()) {
            yAmount = Math.sin(Math.toRadians(this.field_70125_A)) * distance + this.field_70181_x * 0.2;
        }
        this.func_70024_g(xAmount * distance + this.field_70159_w * 0.2, yAmount, zAmount * distance + this.field_70179_y * 0.2);
    }

    public void leap(float range, double leapHeight, Entity target) {
        if (target == null) {
            return;
        }
        this.leap(range, leapHeight, target.func_180425_c());
    }

    public void leap(float range, double leapHeight, BlockPos targetPos) {
        if (targetPos == null) {
            return;
        }
        double distance = MathHelper.func_76133_a((double)targetPos.func_177951_i((Vec3i)this.func_180425_c()));
        if (distance > 2.0 && distance <= (double)range) {
            double xDist = targetPos.func_177958_n() - this.func_180425_c().func_177958_n();
            double zDist = targetPos.func_177952_p() - this.func_180425_c().func_177952_p();
            double xzDist = MathHelper.func_76133_a((double)(xDist * xDist + zDist * zDist));
            this.func_70024_g(xDist / xzDist * 0.5 * 0.8 + this.field_70159_w * 0.2, leapHeight, zDist / xzDist * 0.5 * 0.8 + this.field_70179_y * 0.2);
        }
    }

    public void setHome(int x, int y, int z, float distance) {
        this.setHomePosition(x, y, z);
        this.setHomeDistanceMax(distance);
    }

    public void setHomePosition(int x, int y, int z) {
        this.homePosition = new BlockPos(x, y, z);
    }

    public void setHomeDistanceMax(float newDist) {
        this.homeDistanceMax = newDist;
    }

    public BlockPos getHomePosition() {
        return this.homePosition;
    }

    public float getHomeDistanceMax() {
        return this.homeDistanceMax;
    }

    public void detachHome() {
        this.setHomeDistanceMax(-1.0f);
    }

    public boolean hasHome() {
        return this.getHomePosition() != null && this.getHomeDistanceMax() >= 0.0f;
    }

    public boolean positionNearHome(int x, int y, int z) {
        if (!this.hasHome()) {
            return true;
        }
        return this.getDistanceFromHome(x, y, z) < (double)(this.getHomeDistanceMax() * this.getHomeDistanceMax());
    }

    public double getDistanceFromHome(int x, int y, int z) {
        if (!this.hasHome()) {
            return 0.0;
        }
        return this.homePosition.func_185332_f(x, y, z);
    }

    public double getDistanceFromHome() {
        return this.homePosition.func_185332_f((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
    }

    public boolean hasArenaCenter() {
        return this.getArenaCenter() != null;
    }

    public void setArenaCenter(BlockPos pos) {
        this.arenaCenter = pos;
    }

    public BlockPos getArenaCenter() {
        return this.arenaCenter;
    }

    public BlockPos getWanderPosition(BlockPos wanderPosition) {
        return wanderPosition;
    }

    public int restrictYHeightFromGround(BlockPos coords, int minY, int maxY) {
        int groundY = this.getGroundY(coords);
        int airYMax = Math.min(this.getAirY(coords), groundY + maxY);
        int airYMin = Math.min(airYMax, groundY + minY);
        if (airYMin >= airYMax) {
            return airYMin;
        }
        return airYMin + this.func_70681_au().nextInt(airYMax - airYMin);
    }

    public int getGroundY(BlockPos pos) {
        int y = pos.func_177956_o();
        if (y <= 0) {
            return 0;
        }
        IBlockState startBlock = this.func_130014_f_().func_180495_p(pos);
        if (startBlock == null || startBlock.func_177230_c().isAir(startBlock, (IBlockAccess)this.func_130014_f_(), pos)) {
            IBlockState possibleGroundBlock;
            int possibleGroundY = Math.max(0, y - 1);
            while (possibleGroundY >= 0 && ((possibleGroundBlock = this.func_130014_f_().func_180495_p(new BlockPos(pos.func_177958_n(), possibleGroundY, pos.func_177952_p()))) == null || possibleGroundBlock.func_177230_c().isAir(possibleGroundBlock, (IBlockAccess)this.func_130014_f_(), new BlockPos(pos.func_177958_n(), possibleGroundY, pos.func_177952_p())))) {
                y = possibleGroundY--;
            }
        }
        return y;
    }

    public int getAirY(BlockPos pos) {
        int yMax;
        int y = pos.func_177956_o();
        if (y >= (yMax = this.func_130014_f_().field_73011_w.getActualHeight() - 1)) {
            return yMax;
        }
        if (this.func_130014_f_().func_175710_j(pos)) {
            return yMax;
        }
        IBlockState startBlock = this.func_130014_f_().func_180495_p(pos);
        if (startBlock == null || startBlock.func_177230_c().isAir(startBlock, (IBlockAccess)this.func_130014_f_(), pos)) {
            IBlockState possibleGroundBlock;
            int possibleAirY = Math.min(yMax, y + 1);
            while (possibleAirY <= yMax && ((possibleGroundBlock = this.func_130014_f_().func_180495_p(new BlockPos(pos.func_177958_n(), possibleAirY, pos.func_177952_p()))) == null || possibleGroundBlock.func_177230_c().isAir(possibleGroundBlock, (IBlockAccess)this.func_130014_f_(), new BlockPos(pos.func_177958_n(), possibleAirY, pos.func_177952_p())))) {
                y = possibleAirY++;
            }
        }
        return y;
    }

    public int getWaterSurfaceY(BlockPos pos) {
        int y = pos.func_177956_o();
        if (y <= 0) {
            return 0;
        }
        int yMax = this.func_130014_f_().field_73011_w.getActualHeight() - 1;
        if (y >= yMax) {
            return yMax;
        }
        int yLimit = 24;
        yMax = Math.min(yMax, y + yLimit);
        IBlockState startBlock = this.func_130014_f_().func_180495_p(pos);
        if (startBlock != null && startBlock.func_185904_a() == Material.field_151586_h) {
            int possibleSurfaceY = y;
            ++possibleSurfaceY;
            while (possibleSurfaceY <= yMax) {
                IBlockState possibleSurfaceBlock = this.func_130014_f_().func_180495_p(new BlockPos(pos.func_177958_n(), possibleSurfaceY, pos.func_177952_p()));
                if (possibleSurfaceBlock != null && possibleSurfaceBlock.func_177230_c().isAir(possibleSurfaceBlock, (IBlockAccess)this.func_130014_f_(), new BlockPos(pos.func_177958_n(), possibleSurfaceY, pos.func_177952_p()))) {
                    return possibleSurfaceY;
                }
                if (possibleSurfaceBlock == null || possibleSurfaceBlock.func_185904_a() != Material.field_151586_h) {
                    return possibleSurfaceY - 1;
                }
                ++possibleSurfaceY;
            }
            return Math.max(possibleSurfaceY - 1, y);
        }
        return y;
    }

    protected void func_70105_a(float width, float height) {
        super.func_70105_a(width *= (float)this.sizeScale, height *= (float)this.sizeScale);
        this.hitAreas = null;
        if (!this.func_130014_f_().field_72995_K && this.func_70661_as() != null && this.func_70661_as().func_189566_q() != null && this.func_70661_as().func_189566_q() instanceof ICreatureNodeProcessor) {
            ((ICreatureNodeProcessor)this.func_70661_as().func_189566_q()).updateEntitySize((Entity)this);
        }
    }

    public void updateSize() {
        this.func_70105_a(Math.max(this.setWidth, 0.5f), Math.max(this.setHeight, 0.5f));
    }

    public void setSizeScale(double scale) {
        this.sizeScale = scale;
        this.updateSize();
    }

    public double getRenderScale() {
        return this.sizeScale;
    }

    public boolean func_70686_a(Class targetClass) {
        if (!MobInfo.mobsAttackVillagers && targetClass == EntityVillager.class) {
            return false;
        }
        return !this.isBlocking() || this.canAttackWhileBlocking();
    }

    public boolean canAttackEntity(EntityLivingBase targetEntity) {
        if (!MobInfo.mobsAttackVillagers && targetEntity instanceof EntityVillager) {
            return false;
        }
        if (targetEntity instanceof EntityPlayer) {
            EntityPlayer targetPlayer = (EntityPlayer)targetEntity;
            if (targetPlayer.field_71075_bZ.field_75098_d) {
                return false;
            }
        }
        if (targetEntity instanceof EntityCreatureBase) {
            if (((EntityCreatureBase)targetEntity).getMasterTarget() == this) {
                return false;
            }
            if (!(this instanceof IGroupBoss) && this.getOwner() == null && targetEntity instanceof IGroupBoss && !((EntityCreatureBase)targetEntity).canAttackEntity((EntityLivingBase)this)) {
                return false;
            }
        }
        return this.isStrongSwimmer() || !this.isFlying() || !targetEntity.func_70090_H();
    }

    public EntityLivingBase getMasterAttackTarget() {
        if (this.masterTarget == null) {
            return null;
        }
        if (this.masterTarget instanceof EntityLiving) {
            return ((EntityLiving)this.masterTarget).func_70638_az();
        }
        return null;
    }

    public EntityLivingBase getParentAttackTarget() {
        if (this.parentTarget == null) {
            return null;
        }
        if (this.parentTarget instanceof EntityCreatureBase) {
            return ((EntityCreatureBase)this.parentTarget).func_70638_az();
        }
        if (this.parentTarget instanceof EntityCreature) {
            return ((EntityCreature)this.parentTarget).func_70638_az();
        }
        return null;
    }

    public void func_70604_c(EntityLivingBase entityLivingBase) {
        boolean aggressiveOverride = false;
        if (this.extraMobBehaviour != null) {
            aggressiveOverride = this.extraMobBehaviour.aggressiveOverride;
        }
        if (!aggressiveOverride && this.fleeHealthPercent > 0.0f && this.func_110143_aJ() / this.func_110138_aP() <= this.fleeHealthPercent) {
            this.setAvoidTarget(entityLivingBase);
        } else {
            super.func_70604_c(entityLivingBase);
        }
    }

    public boolean meleeAttack(Entity target, double damageScale) {
        boolean success = true;
        if (this.attackEntityAsMob(target, damageScale) && this.spreadFire && this.func_70027_ad() && (double)this.field_70146_Z.nextFloat() < this.getEffectMultiplier()) {
            target.func_70015_d(this.getEffectDuration(4) / 20);
        }
        this.setJustAttacked();
        return success;
    }

    public void rangedAttack(Entity target, float range) {
        this.setJustAttacked();
    }

    public byte getAttackPhase() {
        return this.getByteFromDataManager(ATTACK_PHASE);
    }

    public void setAttackPhase(byte setAttackPhase) {
        this.attackPhase = setAttackPhase;
    }

    public void nextAttackPhase() {
        this.attackPhase = (byte)(this.attackPhase + 1);
        if (this.attackPhase > this.attackPhaseMax - 1) {
            this.attackPhase = 0;
        }
    }

    public boolean attackEntityAsMob(Entity target, double damageScale) {
        if (!this.func_70089_S()) {
            return false;
        }
        if (target == null) {
            return false;
        }
        if (!this.func_70685_l(target)) {
            return false;
        }
        float damage = this.getAttackDamage(damageScale);
        int i = 0;
        boolean attackSuccess = false;
        float pierceDamage = 1.0f + (float)Math.floor((double)damage / this.getPierceValue());
        if (this.getPierceMultiplier() == 0.0) {
            pierceDamage = 0.0f;
        }
        if (damage <= pierceDamage) {
            attackSuccess = target.func_70097_a(this.getDamageSource(null).func_76348_h().func_151518_m(), damage);
        } else {
            int hurtResistantTimeBefore = target.field_70172_ad;
            target.func_70097_a(this.getDamageSource(null).func_76348_h().func_151518_m(), pierceDamage);
            target.field_70172_ad = hurtResistantTimeBefore;
            attackSuccess = target.func_70097_a(this.getDamageSource(null), damage -= pierceDamage);
        }
        if (attackSuccess) {
            int fireEnchantDuration;
            if (i > 0) {
                target.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((fireEnchantDuration = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                target.func_70015_d(fireEnchantDuration * 4);
            }
        }
        return attackSuccess;
    }

    public float getAttackDamage(double damageScale) {
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        damage += (float)this.getDamageBoost();
        damage = (float)((double)damage * this.getAttackDamageScale());
        damage = (float)((double)damage * damageScale);
        return damage;
    }

    public double getAttackDamageScale() {
        return this.getDamageMultiplier();
    }

    public DamageSource getDamageSource(EntityDamageSource nestedDamageSource) {
        if (nestedDamageSource != null) {
            return nestedDamageSource;
        }
        return DamageSource.func_76358_a((EntityLivingBase)this);
    }

    public boolean func_70097_a(DamageSource damageSrc, float damage) {
        if (this.func_130014_f_().field_72995_K) {
            return false;
        }
        if (this.func_180431_b(damageSrc)) {
            return false;
        }
        if (!this.isDamageTypeApplicable(damageSrc.func_76355_l())) {
            return false;
        }
        if (!this.isDamageEntityApplicable(damageSrc.func_76346_g())) {
            return false;
        }
        damage *= this.getDamageModifier(damageSrc);
        if (damageSrc.func_76346_g() instanceof EntityPlayer) {
            damage = this.getDamageAfterDefense(damage);
        }
        if (this.isBoss() && !(damageSrc.func_76346_g() instanceof EntityPlayer)) {
            damage *= 0.25f;
        }
        if (super.func_70097_a(damageSrc, damage)) {
            this.onDamage(damageSrc, damage);
            Entity entity = damageSrc.func_76364_f();
            if (entity instanceof EntityThrowable) {
                entity = ((EntityThrowable)entity).func_85052_h();
            }
            if (entity != null && !(entity instanceof EntityPlayer)) {
                damage = (damage + 1.0f) / 2.0f;
            }
            if (entity instanceof EntityLivingBase && this.getRider() != entity && this.func_184187_bx() != entity) {
                if (entity != this) {
                    this.func_70604_c((EntityLivingBase)entity);
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean attackEntityFromArea(EntityHitArea entityHitArea, DamageSource damageSrc, float damage) {
        return this.func_70097_a(damageSrc, damage);
    }

    public float getDamageAfterDefense(float damage) {
        float baseDefense = this.defense + this.getDefenseBoost();
        float scaledDefense = baseDefense * (float)this.getDefenseMultiplier();
        float minDamage = 0.0f;
        if (this.isBlocking()) {
            if (scaledDefense <= 0.0f) {
                scaledDefense = 1.0f;
            }
            scaledDefense *= (float)this.getBlockingMultiplier();
        }
        damage -= scaledDefense;
        if (this.damageMax > 0) {
            damage = Math.min(damage, (float)this.damageMax);
        }
        return Math.max(damage, minDamage);
    }

    public void onDamage(DamageSource damageSrc, float damage) {
    }

    public float getDamageModifier(DamageSource damageSrc) {
        return 1.0f;
    }

    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        if (!this.field_70729_aU) {
            return;
        }
        if (!this.func_130014_f_().field_72995_K) {
            if (!this.isBoundPet()) {
                this.inventory.dropInventory();
            }
            if (damageSource.func_76346_g() != null && damageSource.func_76346_g() instanceof EntityPlayer) {
                try {
                    ExtendedPlayer playerExt;
                    EntityPlayer player = (EntityPlayer)damageSource.func_76346_g();
                    player.func_71064_a((StatBase)ObjectManager.getAchievement(this.mobInfo.name + ".kill"), 1);
                    if ((this.isBoss() || this.func_70681_au().nextDouble() <= MobInfo.beastiaryAddOnDeathChance) && (playerExt = ExtendedPlayer.getForPlayer(player)) != null && !playerExt.getBeastiary().hasFullKnowledge(this.mobInfo.name)) {
                        CreatureKnowledge creatureKnowledge = new CreatureKnowledge(playerExt.getBeastiary(), this.mobInfo.name, 1.0);
                        playerExt.getBeastiary().addToKnowledgeList(creatureKnowledge);
                        playerExt.getBeastiary().sendNewToClient(creatureKnowledge);
                        playerExt.getBeastiary().sendAddedMessage(this.mobInfo);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.getMasterTarget() != null && this.getMasterTarget() instanceof EntityCreatureBase) {
            ((EntityCreatureBase)this.getMasterTarget()).onMinionDeath((EntityLivingBase)this);
        }
    }

    public boolean isAggressive() {
        if (this.extraMobBehaviour != null && this.extraMobBehaviour.aggressiveOverride) {
            return true;
        }
        return true;
    }

    public boolean isProtective(Entity entity) {
        return true;
    }

    public boolean hasAttackTarget() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.func_70638_az() != null;
        }
        return (this.getByteFromDataManager(TARGET) & TARGET_ID.ATTACK.id) > 0;
    }

    public EntityLivingBase getMasterTarget() {
        return this.masterTarget;
    }

    public void setMasterTarget(EntityLivingBase setTarget) {
        this.masterTarget = setTarget;
    }

    public boolean hasMaster() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.getMasterTarget() != null;
        }
        return (this.getByteFromDataManager(TARGET) & TARGET_ID.MASTER.id) > 0;
    }

    public EntityLivingBase getParentTarget() {
        return this.parentTarget;
    }

    public void setParentTarget(EntityLivingBase setTarget) {
        this.parentTarget = setTarget;
    }

    public boolean hasParent() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.getParentTarget() != null;
        }
        return (this.getByteFromDataManager(TARGET) & TARGET_ID.PARENT.id) > 0;
    }

    public EntityLivingBase getAvoidTarget() {
        return this.avoidTarget;
    }

    public void setAvoidTarget(EntityLivingBase setTarget) {
        this.currentFleeTime = this.fleeTime;
        this.avoidTarget = setTarget;
    }

    public boolean hasAvoidTarget() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.getAvoidTarget() != null;
        }
        return (this.getByteFromDataManager(TARGET) & TARGET_ID.AVOID.id) > 0;
    }

    public Entity getOwner() {
        return null;
    }

    public EntityLivingBase getRider() {
        if (this.func_184179_bs() instanceof EntityLivingBase) {
            return (EntityLivingBase)this.func_184179_bs();
        }
        return null;
    }

    public void setRiderTarget(Entity setTarget) {
        this.func_184200_o(setTarget);
    }

    public boolean hasRiderTarget() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.func_184179_bs() != null;
        }
        return (this.getByteFromDataManager(TARGET) & TARGET_ID.RIDER.id) > 0;
    }

    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    protected boolean func_184228_n(Entity entity) {
        if (this.isBoss()) {
            return false;
        }
        return super.func_184228_n(entity);
    }

    public BlockPos getFacingPosition(double distance) {
        return this.getFacingPosition((Entity)this, distance, 0.0);
    }

    public BlockPos getFacingPosition(Entity entity, double distance, double angleOffset) {
        return this.getFacingPosition(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, distance, (double)entity.field_70177_z + angleOffset);
    }

    public BlockPos getFacingPosition(double x, double y, double z, double distance, double angle) {
        angle = Math.toRadians(angle);
        double xAmount = -Math.sin(angle);
        double zAmount = Math.cos(angle);
        BlockPos pos = new BlockPos(x + distance * xAmount, y, z + distance * zAmount);
        return pos;
    }

    public Vec3d getFacingPositionDouble(double x, double y, double z, double distance, double angle) {
        angle = Math.toRadians(angle);
        double xAmount = -Math.sin(angle);
        double zAmount = Math.cos(angle);
        Vec3d pos = new Vec3d(x + distance * xAmount, y, z + distance * zAmount);
        return pos;
    }

    public boolean isHostile() {
        return this.isHostileByDefault;
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount) {
            if (this.isMinion()) {
                return false;
            }
            for (EnumCreatureType creatureType : this.mobInfo.spawnInfo.creatureTypes) {
                if (creatureType != type) continue;
                return true;
            }
            return false;
        }
        if (type.func_75598_a() == IMob.class) {
            return this.isHostile();
        }
        return type.func_75598_a().isAssignableFrom(((Object)((Object)this)).getClass());
    }

    public boolean canMove() {
        return !this.isBlocking();
    }

    public boolean canWalk() {
        return true;
    }

    public boolean canWade() {
        return true;
    }

    public boolean canFloat() {
        return !this.func_70648_aU();
    }

    public boolean canDive() {
        return this.func_70648_aU();
    }

    public boolean isStrongSwimmer() {
        return this.extraMobBehaviour != null && this.extraMobBehaviour.swimmingOverride;
    }

    public boolean canJump() {
        return !this.isBlocking();
    }

    public boolean canClimb() {
        return false;
    }

    public boolean isFlying() {
        return this.extraMobBehaviour != null && this.extraMobBehaviour.flightOverride;
    }

    public int getFlyingHeight() {
        if (!this.isFlying()) {
            return 20;
        }
        return 0;
    }

    public boolean isSafeToLand() {
        if (this.field_70122_E) {
            return true;
        }
        if (this.func_130014_f_().func_180495_p(this.func_180425_c().func_177977_b()).func_185904_a().func_76220_a()) {
            return true;
        }
        return this.func_130014_f_().func_180495_p(this.func_180425_c().func_177979_c(2)).func_185904_a().func_76220_a();
    }

    public double getFlightOffset() {
        if (!this.isFlying()) {
            return 0.0;
        }
        return 0.25;
    }

    public boolean isCurrentlyFlying() {
        return this.isFlying();
    }

    public boolean canBeTempted() {
        return this.getSubspeciesIndex() < 3;
    }

    public void onEat() {
    }

    public boolean canStealth() {
        return this.extraMobBehaviour != null && this.extraMobBehaviour.stealthOverride;
    }

    public float getStealth() {
        return this.getFloatFromDataManager(STEALTH);
    }

    public void setStealth(float setStealth) {
        setStealth = Math.min(setStealth, 1.0f);
        setStealth = Math.max(setStealth, 0.0f);
        if (this.func_130014_f_() != null && !this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(STEALTH, (Object)Float.valueOf(setStealth));
        }
    }

    public boolean isStealthed() {
        return this.getStealth() >= 1.0f;
    }

    public void startStealth() {
    }

    public void onStealth() {
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() != null && this.func_70638_az() instanceof EntityLiving && ((EntityLiving)this.func_70638_az()).func_70638_az() != null) {
            ((EntityLiving)this.func_70638_az()).func_70624_b(null);
        }
    }

    public boolean func_70617_f_() {
        if (this.isFlying() || this.isStrongSwimmer()) {
            return false;
        }
        if (this.canClimb()) {
            return (this.getByteFromDataManager(CLIMBING) & 1) != 0;
        }
        return super.func_70617_f_();
    }

    public void setBesideClimbableBlock(boolean collided) {
        if (this.canClimb()) {
            byte climbing = this.getByteFromDataManager(CLIMBING);
            climbing = collided ? (byte)(climbing | 1) : (byte)(climbing & 0xFFFFFFFE);
            this.field_70180_af.func_187227_b(CLIMBING, (Object)climbing);
        }
    }

    public boolean isBesideClimbableBlock() {
        return (this.getByteFromDataManager(CLIMBING) & 1) != 0;
    }

    public void func_180430_e(float fallDistance, float damageMultiplier) {
        if (this.isFlying()) {
            return;
        }
        fallDistance -= this.getFallResistance();
        if (this.getFallResistance() >= 100.0f) {
            fallDistance = 0.0f;
        }
        super.func_180430_e(fallDistance, damageMultiplier);
    }

    protected void func_184231_a(double y, boolean onGround, IBlockState state, BlockPos pos) {
        if (!this.isFlying()) {
            super.func_184231_a(y, onGround, state, pos);
        }
    }

    public void setBlocking() {
        this.currentBlockingTime = this.blockingTime;
    }

    public boolean isBlocking() {
        if (this.func_130014_f_().field_72995_K) {
            return (this.getByteFromDataManager(ANIMATION) & ANIM_ID.BLOCKING.id) > 0;
        }
        return this.currentBlockingTime > 0;
    }

    public boolean canAttackWhileBlocking() {
        return false;
    }

    public int getBlockingMultiplier() {
        return 4;
    }

    public boolean canPickupEntity(EntityLivingBase entity) {
        if (this.getPickupEntity() == entity) {
            return false;
        }
        if (entity instanceof IGroupBoss || entity instanceof IGroupHeavy) {
            return false;
        }
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(entity);
        if (extendedEntity == null) {
            return false;
        }
        if (entity.func_184187_bx() != null && !(entity.func_184187_bx() instanceof EntityBoat) && !(entity.func_184187_bx() instanceof EntityMinecart) || entity.func_184179_bs() != null) {
            return false;
        }
        if (ObjectManager.getPotionEffect("weight") != null && entity.func_70644_a((Potion)ObjectManager.getPotionEffect("weight"))) {
            return false;
        }
        return extendedEntity.pickedUpByEntity == null || extendedEntity.pickedUpByEntity instanceof EntityFear;
    }

    public void pickupEntity(EntityLivingBase entity) {
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(entity);
        if (extendedEntity != null) {
            extendedEntity.setPickedUpByEntity((Entity)this);
        }
        this.pickupEntity = entity;
        this.clearMovement();
    }

    public EntityLivingBase getPickupEntity() {
        return this.pickupEntity;
    }

    public boolean hasPickupEntity() {
        return this.getPickupEntity() != null;
    }

    public void dropPickupEntity() {
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(this.getPickupEntity());
        if (extendedEntity != null) {
            extendedEntity.setPickedUpByEntity(null);
        }
        this.pickupEntity = null;
    }

    public double[] getPickupOffset(Entity entity) {
        return new double[]{0.0, 0.0, 0.0};
    }

    public void destroyArea(int x, int y, int z, float strength, boolean drop) {
        this.destroyArea(x, y, z, strength, drop, 0);
    }

    public void destroyArea(int x, int y, int z, float strength, boolean drop, int range) {
        int w = -((int)Math.ceil(this.field_70130_N) + range);
        while ((double)w <= Math.ceil(this.field_70130_N) + (double)range) {
            int d = -((int)Math.ceil(this.field_70130_N) + range);
            while ((double)d <= Math.ceil(this.field_70130_N) + (double)range) {
                int h = 0;
                while ((double)h <= Math.ceil(this.field_70131_O)) {
                    IBlockState blockState = this.func_130014_f_().func_180495_p(new BlockPos(x + w, y + h, z + d));
                    if (blockState != null) {
                        float hardness = blockState.func_185887_b(this.func_130014_f_(), new BlockPos(x + w, y + h, z + d));
                        Material material = blockState.func_185904_a();
                        if (hardness >= 0.0f && strength >= hardness && strength >= blockState.func_177230_c().func_149638_a((Entity)this) && material != Material.field_151586_h && material != Material.field_151587_i) {
                            this.func_130014_f_().func_175655_b(new BlockPos(x + w, y + h, z + d), drop);
                        }
                    }
                    ++h;
                }
                ++d;
            }
            ++w;
        }
    }

    public boolean extraAnimation01() {
        return this.extraAnimation01;
    }

    protected Item func_146068_u() {
        if (this.drops != null && this.drops.get(0) != null && !this.isMinion() && !this.isBoundPet()) {
            return this.drops.get((int)0).item.func_77973_b();
        }
        return null;
    }

    protected void func_70628_a(boolean playerKill, int lootLevel) {
        if (this.func_130014_f_().field_72995_K || this.isMinion() || this.isBoundPet()) {
            return;
        }
        int subspeciesScale = 1;
        if (this.getSubspeciesIndex() > 2) {
            subspeciesScale = Subspecies.rareDropScale;
        } else if (this.getSubspeciesIndex() > 0) {
            subspeciesScale = Subspecies.uncommonDropScale;
        }
        for (DropRate dropRate : this.drops) {
            if (dropRate.subspeciesID >= 0 && dropRate.subspeciesID != this.getSubspeciesIndex()) continue;
            int quantity = dropRate.getQuantity(this.field_70146_Z, lootLevel);
            if (dropRate.subspeciesID < 0) {
                quantity *= subspeciesScale;
            }
            if (this.extraMobBehaviour != null && this.extraMobBehaviour.itemDropMultiplierOverride != 1.0) {
                quantity = Math.round((float)quantity * (float)this.extraMobBehaviour.itemDropMultiplierOverride);
            }
            ItemStack dropStack = null;
            if (quantity > 0) {
                dropStack = dropRate.getItemStack((EntityLivingBase)this, quantity);
            }
            if (dropStack == null) continue;
            this.dropItem(dropStack);
        }
    }

    public void dropItem(ItemStack itemStack) {
        this.func_70099_a(itemStack, 0.0f);
    }

    public EntityItem func_70099_a(ItemStack itemStack, float heightOffset) {
        if (itemStack.func_190916_E() != 0 && itemStack.func_77973_b() != null) {
            EntityItemCustom entityItem = new EntityItemCustom(this.func_130014_f_(), this.field_70165_t, this.field_70163_u + (double)heightOffset, this.field_70161_v, itemStack);
            entityItem.func_174867_a(10);
            this.applyDropEffects(entityItem);
            if (this.captureDrops) {
                this.capturedDrops.add(entityItem);
            } else {
                this.func_130014_f_().func_72838_d((Entity)entityItem);
            }
            return entityItem;
        }
        return null;
    }

    public void applyDropEffects(EntityItemCustom entityItem) {
    }

    public void openGUI(EntityPlayer player) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        this.addGUIViewer(player);
        this.refreshGUIViewers();
        this.openGUIToPlayer(player);
    }

    public void addGUIViewer(EntityPlayer player) {
        if (!this.func_130014_f_().field_72995_K) {
            this.guiViewers.add(player);
        }
    }

    public void removeGUIViewer(EntityPlayer player) {
        if (!this.func_130014_f_().field_72995_K) {
            this.guiViewers.remove(player);
        }
    }

    public void refreshGUIViewers() {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.guiViewers.size() > 0) {
            for (EntityPlayer player : this.guiViewers.toArray(new EntityPlayer[this.guiViewers.size()])) {
                if (player.field_71070_bA == null || !(player.field_71070_bA instanceof ContainerCreature)) continue;
                if (((ContainerCreature)player.field_71070_bA).creature == this) {
                    this.openGUIToPlayer(player);
                    continue;
                }
                this.removeGUIViewer(player);
            }
        }
    }

    public void openGUIToPlayer(EntityPlayer player) {
        if (player != null) {
            player.openGui((Object)LycanitesMobs.instance, (int)GuiHandler.GuiType.ENTITY.id, this.func_130014_f_(), this.func_145782_y(), 0, 0);
        }
    }

    public void scheduleGUIRefresh() {
        this.guiRefreshTick = this.guiRefreshTime + 1;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.assessInteractCommand(this.getInteractCommands(player, player.func_184586_b(hand)), player, player.func_184586_b(hand))) {
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean assessInteractCommand(HashMap<Integer, String> commands, EntityPlayer player, ItemStack itemStack) {
        if (commands.isEmpty()) {
            return false;
        }
        int priority = 100;
        for (int testPriority : commands.keySet()) {
            if (testPriority >= priority) continue;
            priority = testPriority;
        }
        if (!commands.containsKey(priority)) {
            return false;
        }
        this.performCommand(commands.get(priority), player, itemStack);
        return true;
    }

    public HashMap<Integer, String> getInteractCommands(EntityPlayer player, ItemStack itemStack) {
        HashMap<Integer, String> commands = new HashMap<Integer, String>();
        if (itemStack != null) {
            if (itemStack.func_77973_b() == Items.field_151058_ca && this.func_184652_a(player)) {
                commands.put(CMD_PRIOR.ITEM_USE.id, "Leash");
            }
            if (itemStack.func_77973_b() == Items.field_151057_cb) {
                if (this.canNameTag(player)) {
                    return new HashMap<Integer, String>();
                }
                commands.put(CMD_PRIOR.ITEM_USE.id, "Name Tag");
            }
            if (this.canBeColored(player) && itemStack.func_77973_b() == Items.field_151100_aR) {
                commands.put(CMD_PRIOR.ITEM_USE.id, "Color");
            }
        }
        return commands;
    }

    public void performCommand(String command, EntityPlayer player, ItemStack itemStack) {
        int colorID;
        if ("Leash".equals(command)) {
            this.func_110162_b((Entity)player, true);
            this.consumePlayersItem(player, itemStack);
        }
        if ("Color".equals(command) && (colorID = 15 - itemStack.func_77952_i()) != this.getColor()) {
            this.setColor(colorID);
            this.consumePlayersItem(player, itemStack);
        }
    }

    public boolean canNameTag(EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_94059_bO() {
        if (this.renderSubspeciesNameTag() && this.getSubspecies() != null) {
            return MobInfo.subspeciesTags;
        }
        return super.func_94059_bO();
    }

    public boolean renderSubspeciesNameTag() {
        return true;
    }

    public void consumePlayersItem(EntityPlayer player, ItemStack itemStack) {
        this.consumePlayersItem(player, itemStack, 1);
    }

    public void consumePlayersItem(EntityPlayer player, ItemStack itemStack, int amount) {
        if (!player.field_71075_bZ.field_75098_d) {
            itemStack.func_190920_e(Math.max(0, itemStack.func_190916_E() - amount));
        }
        if (itemStack.func_190916_E() <= 0) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
        }
    }

    public void replacePlayersItem(EntityPlayer player, ItemStack itemStack, ItemStack newStack) {
        this.replacePlayersItem(player, itemStack, 1, newStack);
    }

    public void replacePlayersItem(EntityPlayer player, ItemStack itemStack, int amount, ItemStack newStack) {
        if (!player.field_71075_bZ.field_75098_d) {
            itemStack.func_190920_e(Math.max(0, itemStack.func_190916_E() - amount));
        }
        if (itemStack.func_190916_E() <= 0) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, newStack);
        } else if (!player.field_71071_by.func_70441_a(newStack)) {
            player.func_71019_a(newStack, false);
        }
    }

    public void performGUICommand(EntityPlayer player, byte guiCommandID) {
        this.scheduleGUIRefresh();
    }

    public boolean canCarryItems() {
        return this.getInventorySize() > 0;
    }

    public int getInventorySize() {
        return this.inventory.func_70302_i_();
    }

    public int getInventorySizeMax() {
        return Math.max(this.getNoBagSize(), this.getBagSize());
    }

    public boolean hasBag() {
        return this.inventory.getEquipmentStack("bag") != null;
    }

    public int getNoBagSize() {
        if (this.extraMobBehaviour != null && this.extraMobBehaviour.inventorySizeOverride > 0) {
            return this.extraMobBehaviour.inventorySizeOverride;
        }
        return 0;
    }

    public int getBagSize() {
        return 5;
    }

    public boolean canPickupItems() {
        return this.extraMobBehaviour != null && this.extraMobBehaviour.itemPickupOverride;
    }

    public int getSpaceForStack(ItemStack pickupStack) {
        return this.inventory.getSpaceForStack(pickupStack);
    }

    public boolean canEquip() {
        return this.mobInfo.isTameable();
    }

    public void setCurrentItemOrArmor(int slot, ItemStack itemStack) {
        String type = "item";
        if (slot == 0) {
            type = "weapon";
        }
        if (slot == 1) {
            type = "feet";
        }
        if (slot == 2) {
            type = "legs";
        }
        if (slot == 3) {
            type = "chest";
        }
        if (slot == 4) {
            type = "head";
        }
        if (slot == 100) {
            type = "bag";
        }
        this.inventory.setEquipmentStack(type, itemStack);
    }

    public String getEquipmentName(String type) {
        if (this.inventory.getEquipmentGrade(type) != null) {
            return type + this.inventory.getEquipmentGrade(type);
        }
        return null;
    }

    public int func_70658_aO() {
        return this.inventory.getArmorValue();
    }

    public void pickupItems() {
        List list = this.func_130014_f_().func_72872_a(EntityItem.class, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0));
        for (EntityItem entityItem : list) {
            ItemStack itemStack;
            int space;
            if (entityItem.field_70128_L || entityItem.func_92059_d() == null || (space = this.getSpaceForStack(itemStack = entityItem.func_92059_d())) <= 0) continue;
            this.onPickupStack(itemStack);
            this.doItemPickup(entityItem);
        }
    }

    public void onPickupStack(ItemStack itemStack) {
    }

    public void doItemPickup(EntityItem entityItem) {
        if (!entityItem.field_70128_L && entityItem.func_92059_d() != null) {
            ItemStack leftoverStack = this.inventory.autoInsertStack(entityItem.func_92059_d());
            if (leftoverStack != null) {
                entityItem.func_92058_a(leftoverStack);
            } else {
                entityItem.func_70106_y();
            }
        }
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source);
    }

    public boolean isDamageTypeApplicable(String type) {
        return !"inWall".equals(type) && !"cactus".equals(type) || this.getSubspeciesIndex() < 3 && !this.isBoss();
    }

    public boolean isDamageEntityApplicable(Entity entity) {
        if (this.isBoss()) {
            if (entity == null) {
                return false;
            }
            return this.func_70032_d(entity) <= (float)this.bossRange;
        }
        return true;
    }

    public boolean func_70687_e(PotionEffect potionEffect) {
        return super.func_70687_e(potionEffect);
    }

    public boolean canBurn() {
        return this.extraMobBehaviour == null || !this.extraMobBehaviour.fireImmunityOverride;
    }

    public boolean daylightBurns() {
        return false;
    }

    public boolean canFreeze() {
        return !(this instanceof IGroupIce);
    }

    public boolean waterDamage() {
        return false;
    }

    public boolean webProof() {
        return false;
    }

    public void func_70110_aj() {
        if (!this.webProof()) {
            super.func_70110_aj();
        }
    }

    public boolean func_70648_aU() {
        return this.extraMobBehaviour != null && this.extraMobBehaviour.waterBreathingOverride;
    }

    public boolean canBreatheAboveWater() {
        return true;
    }

    public void func_70050_g(int air) {
        if (air == 300 && !this.canBreatheAboveWater()) {
            return;
        }
        super.func_70050_g(air);
    }

    public boolean func_70090_H() {
        if (this.isLavaCreature) {
            return this.func_180799_ab() || super.func_70090_H();
        }
        return super.func_70090_H();
    }

    public boolean waterContact() {
        if (this.func_70026_G()) {
            return true;
        }
        return this.func_130014_f_().func_72896_J() && !this.isBlockUnderground((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
    }

    public boolean lavaContact() {
        return this.func_180799_ab();
    }

    public boolean canBreatheAtLocation(BlockPos pos) {
        IBlockState blockState = this.func_130014_f_().func_180495_p(pos);
        if (blockState == null) {
            return true;
        }
        if (this.canBreatheAboveWater() && blockState.func_185904_a() == Material.field_151579_a) {
            return true;
        }
        if (this.func_70648_aU()) {
            if (!this.isLavaCreature && blockState.func_185904_a() == Material.field_151586_h) {
                return true;
            }
            if (this.isLavaCreature && blockState.func_185904_a() == Material.field_151587_i) {
                return true;
            }
        }
        return false;
    }

    public boolean isSwimmable(int x, int y, int z) {
        IBlockState blockState = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z));
        if (blockState == null) {
            return false;
        }
        if (this.isLavaCreature && Material.field_151587_i.equals(blockState.func_185904_a())) {
            return true;
        }
        return Material.field_151586_h.equals(blockState.func_185904_a());
    }

    public float getFallResistance() {
        return 0.0f;
    }

    public byte testLightLevel() {
        return this.testLightLevel(this.func_180425_c());
    }

    public byte testLightLevel(BlockPos pos) {
        IBlockState spawnBlockState = this.func_130014_f_().func_180495_p(pos);
        if (pos.func_177956_o() < 0) {
            return 0;
        }
        pos = spawnBlockState != null && spawnBlockState.func_185904_a() == Material.field_151586_h && SpawnInfo.useSurfaceLightLevel ? new BlockPos(pos.func_177958_n(), this.getWaterSurfaceY(pos), pos.func_177952_p()) : new BlockPos(pos.func_177958_n(), this.getGroundY(pos), pos.func_177952_p());
        int light = this.func_130014_f_().func_175671_l(pos);
        if (this.func_130014_f_().func_72911_I()) {
            int originalSkylight = this.func_130014_f_().func_175657_ab();
            this.func_130014_f_().func_175692_b(10);
            light = this.func_130014_f_().func_175671_l(pos);
            this.func_130014_f_().func_175692_b(originalSkylight);
        }
        if (light == 0) {
            return 0;
        }
        if (light <= 7) {
            return 1;
        }
        if (light <= 14) {
            return 2;
        }
        return 3;
    }

    public boolean isDaytime() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.func_130014_f_().func_72935_r();
        }
        long time = this.func_130014_f_().func_72820_D();
        if (time < 12500L) {
            return true;
        }
        return time < 12542L || time >= 23460L;
    }

    public int nearbyCreatureCount(Class targetClass, double range) {
        return this.getNearbyEntities(Entity.class, targetClass, range).size();
    }

    public EnumCreatureAttribute func_70668_bt() {
        return this.attribute;
    }

    public double func_70042_X() {
        return super.func_70042_X() - 0.5;
    }

    public <T extends Entity> List<T> getNearbyEntities(Class<? extends T> clazz, final Class filterClass, double range) {
        return this.func_130014_f_().func_175647_a(clazz, this.func_174813_aQ().func_72314_b(range, range, range), (Predicate)new Predicate<Entity>(){

            public boolean apply(Entity entity) {
                if (filterClass == null) {
                    return true;
                }
                return filterClass.isAssignableFrom(entity.getClass());
            }
        });
    }

    public <T extends Entity> T getNearestEntity(Class<? extends T> clazz, Class filterClass, double range, boolean canAttack) {
        List<T> aoeTargets = this.getNearbyEntities(clazz, filterClass, range);
        if (aoeTargets.size() == 0) {
            return null;
        }
        double nearestDistance = range + 10.0;
        Entity nearestEntity = null;
        for (T entityObj : aoeTargets) {
            double distance;
            Entity targetEntity = (Entity)entityObj;
            if (canAttack && (!(targetEntity instanceof EntityLivingBase) || !this.canAttackEntity((EntityLivingBase)targetEntity)) || targetEntity == this.func_184179_bs() || !((distance = (double)this.func_70032_d(targetEntity)) < nearestDistance)) continue;
            nearestDistance = distance;
            nearestEntity = targetEntity;
        }
        return (T)nearestEntity;
    }

    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        this.firstSpawn = nbtTagCompound.func_74764_b("FirstSpawn") ? nbtTagCompound.func_74767_n("FirstSpawn") : true;
        if (nbtTagCompound.func_74764_b("SpawnEventType")) {
            this.spawnEventType = nbtTagCompound.func_74779_i("SpawnEventType");
        }
        if (nbtTagCompound.func_74764_b("SpawnEventCount")) {
            this.spawnEventCount = nbtTagCompound.func_74762_e("SpawnEventCount");
        }
        if (nbtTagCompound.func_74764_b("Stealth")) {
            this.setStealth(nbtTagCompound.func_74760_g("Stealth"));
        }
        if (nbtTagCompound.func_74764_b("IsMinion")) {
            this.setMinion(nbtTagCompound.func_74767_n("IsMinion"));
        }
        if (nbtTagCompound.func_74764_b("IsTemporary") && nbtTagCompound.func_74767_n("IsTemporary") && nbtTagCompound.func_74764_b("TemporaryDuration")) {
            this.setTemporary(nbtTagCompound.func_74762_e("TemporaryDuration"));
        } else {
            this.unsetTemporary();
        }
        if (nbtTagCompound.func_74764_b("IsBoundPet") && nbtTagCompound.func_74767_n("IsBoundPet") && !this.hasPetEntry()) {
            this.func_70106_y();
        }
        if (nbtTagCompound.func_74764_b("ForceNoDespawn")) {
            this.forceNoDespawn = nbtTagCompound.func_74767_n("ForceNoDespawn");
        }
        if (nbtTagCompound.func_74764_b("Color")) {
            this.setColor(nbtTagCompound.func_74771_c("Color"));
        }
        if (nbtTagCompound.func_74764_b("Subspecies")) {
            this.setSubspecies(nbtTagCompound.func_74771_c("Subspecies"), false);
        }
        if (nbtTagCompound.func_74764_b("Size")) {
            this.sizeScale = nbtTagCompound.func_74769_h("Size");
            this.updateSize();
        }
        super.func_70037_a(nbtTagCompound);
        this.inventory.readFromNBT(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("ExtraBehaviour")) {
            this.extraMobBehaviour.readFromNBT(nbtTagCompound.func_74775_l("ExtraBehaviour"));
        }
        if (nbtTagCompound.func_74764_b("HomeX") && nbtTagCompound.func_74764_b("HomeY") && nbtTagCompound.func_74764_b("HomeZ") && nbtTagCompound.func_74764_b("HomeDistanceMax")) {
            this.setHome(nbtTagCompound.func_74762_e("HomeX"), nbtTagCompound.func_74762_e("HomeY"), nbtTagCompound.func_74762_e("HomeZ"), nbtTagCompound.func_74760_g("HomeDistanceMax"));
        }
        if (nbtTagCompound.func_74764_b("ArenaX") && nbtTagCompound.func_74764_b("ArenaY") && nbtTagCompound.func_74764_b("ArenaZ")) {
            this.setArenaCenter(new BlockPos(nbtTagCompound.func_74762_e("ArenaX"), nbtTagCompound.func_74762_e("ArenaY"), nbtTagCompound.func_74762_e("ArenaZ")));
        }
    }

    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74757_a("FirstSpawn", this.firstSpawn);
        nbtTagCompound.func_74778_a("SpawnEventType", this.spawnEventType);
        nbtTagCompound.func_74768_a("SpawnEventCount", this.spawnEventCount);
        nbtTagCompound.func_74776_a("Stealth", this.getStealth());
        nbtTagCompound.func_74757_a("IsMinion", this.isMinion());
        nbtTagCompound.func_74757_a("IsTemporary", this.isTemporary);
        nbtTagCompound.func_74768_a("TemporaryDuration", this.temporaryDuration);
        nbtTagCompound.func_74757_a("IsBoundPet", this.isBoundPet());
        nbtTagCompound.func_74757_a("ForceNoDespawn", this.forceNoDespawn);
        nbtTagCompound.func_74774_a("Color", (byte)this.getColor());
        nbtTagCompound.func_74774_a("Subspecies", (byte)this.getSubspeciesIndex());
        nbtTagCompound.func_74780_a("Size", this.sizeScale);
        if (this.hasHome()) {
            BlockPos homePos = this.getHomePosition();
            nbtTagCompound.func_74768_a("HomeX", homePos.func_177958_n());
            nbtTagCompound.func_74768_a("HomeY", homePos.func_177956_o());
            nbtTagCompound.func_74768_a("HomeZ", homePos.func_177952_p());
            nbtTagCompound.func_74776_a("HomeDistanceMax", this.getHomeDistanceMax());
        }
        if (this.hasArenaCenter()) {
            BlockPos arenaPos = this.getArenaCenter();
            nbtTagCompound.func_74768_a("ArenaX", arenaPos.func_177958_n());
            nbtTagCompound.func_74768_a("ArenaY", arenaPos.func_177956_o());
            nbtTagCompound.func_74768_a("ArenaZ", arenaPos.func_177952_p());
        }
        super.func_70014_b(nbtTagCompound);
        this.inventory.writeToNBT(nbtTagCompound);
        NBTTagCompound extTagCompound = new NBTTagCompound();
        this.extraMobBehaviour.writeToNBT(extTagCompound);
        nbtTagCompound.func_74782_a("ExtraBehaviour", (NBTBase)extTagCompound);
    }

    public boolean justAttacked() {
        return this.justAttacked > 0;
    }

    public void setJustAttacked() {
        this.justAttacked = this.justAttackedTime;
    }

    public ResourceLocation getTexture() {
        String textureName = this.getTextureName();
        if (this.getSubspecies() != null) {
            textureName = textureName + "_" + this.getSubspecies().name;
        }
        if (AssetManager.getTexture(textureName) == null) {
            AssetManager.addTexture(textureName, this.group, "textures/entity/" + textureName.toLowerCase() + ".png");
        }
        return AssetManager.getTexture(textureName);
    }

    public ResourceLocation getEquipmentTexture(String equipmentName) {
        if (!this.canEquip()) {
            return this.getTexture();
        }
        return this.getSubTexture(equipmentName);
    }

    public ResourceLocation getSubTexture(String subName) {
        subName = subName.toLowerCase();
        String textureName = this.getTextureName();
        if (AssetManager.getTexture(textureName = textureName + "_" + subName) == null) {
            AssetManager.addTexture(textureName, this.group, "textures/entity/" + textureName.toLowerCase() + ".png");
        }
        return AssetManager.getTexture(textureName);
    }

    public String getTextureName() {
        return this.mobInfo.name;
    }

    public boolean canBeColored(EntityPlayer player) {
        return false;
    }

    public int getColor() {
        if (this.func_184212_Q() == null) {
            return 0;
        }
        return Integer.valueOf(((Byte)this.func_184212_Q().func_187225_a(COLOR)).byteValue()) & 0xF;
    }

    public void setColor(int color) {
        if (this.func_130014_f_() != null && !this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(COLOR, (Object)((byte)(color & 0xF)));
        }
    }

    public boolean showBossInfo() {
        if (this.forceBossHealthBar || this.isBoss()) {
            return true;
        }
        if (this.getSubspeciesIndex() >= 3) {
            return Subspecies.rareHealthBars;
        }
        return false;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        if (this.getBossInfo() != null) {
            this.bossInfo.func_186760_a(player);
        }
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        if (this.getBossInfo() != null) {
            this.bossInfo.func_186761_b(player);
        }
    }

    protected float func_70599_aP() {
        if (this.isBoss()) {
            return 4.0f;
        }
        if (this.getSubspeciesIndex() >= 3) {
            return 2.0f;
        }
        return 1.0f;
    }

    public int func_70627_aG() {
        return 80;
    }

    protected SoundEvent func_184639_G() {
        return AssetManager.getSound(this.mobInfo.name + "_say");
    }

    protected SoundEvent func_184601_bQ() {
        return AssetManager.getSound(this.mobInfo.name + "_hurt");
    }

    protected SoundEvent func_184615_bR() {
        return AssetManager.getSound(this.mobInfo.name + "_death");
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        if (this.isCurrentlyFlying()) {
            return;
        }
        if (!this.hasStepSound) {
            super.func_180429_a(pos, block);
            return;
        }
        this.func_184185_a(AssetManager.getSound(this.mobInfo.name + "_step"), this.func_70599_aP(), 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    protected SoundEvent func_184588_d(int height) {
        return height > 4 ? SoundEvents.field_187735_cx : SoundEvents.field_187589_cA;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187591_cB;
    }

    public void playJumpSound() {
        if (!this.hasJumpSound) {
            return;
        }
        this.func_184185_a(AssetManager.getSound(this.mobInfo.name + "_jump"), this.func_70599_aP(), 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public void playFlySound() {
        if (!this.isFlying()) {
            return;
        }
        this.func_184185_a(AssetManager.getSound(this.mobInfo.name + "_fly"), this.func_70599_aP(), 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public void playAttackSound() {
        if (!this.hasAttackSound) {
            return;
        }
        this.func_184185_a(AssetManager.getSound(this.mobInfo.name + "_attack"), this.func_70599_aP(), 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public void playPhaseSound() {
        if (AssetManager.getSound(this.mobInfo.name + "_phase") == null) {
            return;
        }
        this.func_184185_a(AssetManager.getSound(this.mobInfo.name + "_phase"), this.func_70599_aP() * 2.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public void func_184185_a(SoundEvent sound, float volume, float pitch) {
        if (sound == null) {
            return;
        }
        super.func_184185_a(sound, volume, pitch);
    }

    public class GroupData
    implements IEntityLivingData {
        public boolean isChild;

        public GroupData(boolean child) {
            this.isChild = child;
        }
    }

    public static enum GUI_COMMAND_ID {
        CLOSE(0),
        SITTING(1),
        FOLLOWING(2),
        PASSIVE(3),
        STANCE(4),
        PVP(5),
        TELEPORT(6),
        SPAWNING(7),
        RELEASE(8);

        public byte id;

        private GUI_COMMAND_ID(byte i) {
            this.id = i;
        }
    }

    public static enum CMD_PRIOR {
        OVERRIDE(0),
        IMPORTANT(1),
        EQUIPPING(2),
        ITEM_USE(3),
        EMPTY_HAND(4),
        MAIN(5);

        public final int id;

        private CMD_PRIOR(int value) {
            this.id = value;
        }

        public int getValue() {
            return this.id;
        }
    }

    public static enum ANIM_ID {
        ATTACKED(1),
        GROUNDED(2),
        IN_WATER(4),
        BLOCKING(8),
        MINION(16),
        EXTRA01(32);

        public final byte id;

        private ANIM_ID(byte value) {
            this.id = value;
        }

        public byte getValue() {
            return this.id;
        }
    }

    public static enum TARGET_ID {
        ATTACK(1),
        MASTER(2),
        PARENT(4),
        AVOID(8),
        RIDER(16);

        public final byte id;

        private TARGET_ID(byte value) {
            this.id = value;
        }

        public byte getValue() {
            return this.id;
        }
    }
}

